/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * $Id: BFAGMethodEntryParser.java,v 1.4 2008/05/19 14:49:54 jkubasta Exp $
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFAGMethodEntryParser extends BinaryFragmentParser {

	public static final Short ID = new Short((short) 1036);
	
	public static final String NAME = "agMethodEntry"; 

	public BFAGMethodEntryParser() {
		super(ID, NAME);
	}

	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();

		loader.addAttribute(THREAD_ID_REF, (int) reader.readLong(data, offset));
		loader.addAttribute(METHOD_ID_REF, (int) reader.readLong(data, offset));
		loader.addAttribute(BASE_TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(MIN_TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(MAX_TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(CPU_TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(COUNT, (int)reader.readLong(data, offset));
		
		return true;
	}
}
