/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BFAgentCreateParser.java,v 1.3 2008/05/19 14:49:54 jkubasta Exp $
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFAgentCreateParser extends BinaryFragmentParser {

	public static final Short ID = new Short((short)1003);

	public static final String NAME = "agentCreate";

	public BFAgentCreateParser() {
		super(ID, NAME);
	}

	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();
		
		loader.addAttribute(AGENT_ID, reader.readString(data, offset));
		loader.addAttribute(PROCESS_ID_REF, reader.readString(data, offset));
		loader.addAttribute(AGENT_NAME, reader.readString(data, offset));
		loader.addAttribute(AGENT_TYPE, reader.readString(data, offset));
		loader.addAttribute(TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(AGENT_PARAMETERS, reader.readString(data, offset));
		loader.addAttribute(VERSION, reader.readString(data, offset));
		
		return true;
	}
}
