/**********************************************************************
 * Copyright (c) 2008 IBM Corporation, Intel Corporation.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: BFMonNotifyCalledParser.java,v 1.3 2008/05/19 14:49:54 jkubasta Exp $
 *
 * Contributors:
 * Stas Polevic - Initial contribution
 **********************************************************************/

package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFMonNotifyCalledParser extends BinaryFragmentParser {

	public static final Short ID = new Short((short) 1042);
	
	public static final String NAME = "monNotifyCalled"; 

	public BFMonNotifyCalledParser() {
		super(ID, NAME);
	}
	
	protected BFMonNotifyCalledParser(Short id, String name) {
		super(id, name);
	}
	
	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();

		loader.addAttribute(THREAD_ID_REF, (int) reader.readLong(data, offset));
		loader.addAttribute(TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(OBJ_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(IS_NOTIFY_ALL, reader.readByte(data, offset));
		
		long stackDepth = reader.readUnsignedInt(data, offset);
		
		String[] stackMethods = reader.readStringArray(data, (int)stackDepth, offset); // Possible truncation
		addAnnotation(loader, stackMethods, CALL_STACK_METHODS);

		Long[] stackLines = reader.readLongArray(data, (int)stackDepth, offset);
		addAnnotation(loader, stackLines, CALL_STACK_LINES);
		
		return true;
	}
}
