/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BFNodeParser.java,v 1.3 2008/05/19 14:49:55 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFNodeParser extends BinaryFragmentParser {
	
	public static final Short ID = new Short((short)1001);

	public static final String NAME = "node";

	public BFNodeParser() {
		super(ID, NAME);
	}
	
	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();

		loader.addAttribute(NODE_ID, reader.readString(data, offset));
		loader.addAttribute(HOSTNAME, reader.readString(data, offset));
		loader.addAttribute(IPADDRESS, reader.readString(data, offset));
		loader.addAttribute(TIMEZONE, reader.readTimestampAsString(data, offset));
		loader.addAttribute(TIMESTAMP, reader.readLong(data, offset));
		
		return true;
	}
}
