/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BFObjFreeParser.java,v 1.3 2008/05/19 14:49:54 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFObjFreeParser extends BinaryFragmentParser {

	public static final Short ID = new Short((short)1024);

	public static final String NAME = "objFree";

	public BFObjFreeParser() {
		super(ID, NAME);
	}
	
	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();

		loader.addAttribute(TRANS_THREAD_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(THREAD_ID_REF, (int)reader.readLong(data, offset));
		loader.addAttribute(TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(TRANS_OBJ_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(OBJ_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(OBJ_AGE, reader.readLong(data, offset));
		loader.addAttribute(SEQUENCE_COUNTER, reader.readLong(data, offset));
		loader.addAttribute(STACK_DEPTH, reader.readLong(data, offset));
		loader.addAttribute(COLLATION_VALUE, reader.readString(data, offset));
		loader.addAttribute(TRACE_ID_REF, reader.readString(data, offset));
		
		return true;
	}

}
