/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BFProcessCreateParser.java,v 1.4 2008/05/19 14:49:54 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFProcessCreateParser extends BinaryFragmentParser {
	public static final Short ID = new Short((short)1002);

	public static final String NAME = "processCreate";

	public BFProcessCreateParser() {
		super(ID, NAME);
	}
	
	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();

		loader.addAttribute(PROCESS_ID, reader.readString(data, offset));
		loader.addAttribute(NAME_ATTR, reader.readString(data, offset));
		loader.addAttribute(PID, reader.readUnsignedInt(data, offset));
		loader.addAttribute(NODE_ID_REF, reader.readString(data, offset));
		loader.addAttribute(TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(APPLICATION_EXECUTABLE, reader.readString(data, offset));
		
		return true;
	}

}
