/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesResourceExtensions.java,v 1.2 2008/01/24 02:28:17 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.plugin.ModelsHierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.ObjectToIntMap;
import org.eclipse.hyades.models.hierarchy.util.internal.ObjectToIntMapImpl;
import org.eclipse.hyades.models.util.ModelDebugger;
/**
 * @author slavescu
 */
public class HyadesResourceExtensions extends HashMap {
	/**
	 * 
	 */
	protected static final long serialVersionUID = 3616443484370843185L;
	protected static HyadesResourceExtensions instance;
	protected IHyadesResourceExtension defaultHyadesResourceFactory;
	protected Properties defaultProperties = new Properties();
	protected HashMap allProperties;
	protected ObjectToIntMap classIdMap;
	protected String[] classIdArray={
		/*0*/	"1","Hierarchy_AbstractDefaultEvent", //AbstractDefaultEvent
		/*1*/	"2","Hierarchy_AbstractTRCCollectionBoundary", //AbstractTRCCollectionBoundary
		/*2*/	"3","Hierarchy_AbstractTRCDescription", //AbstractTRCDescription
		/*3*/	"4","Hierarchy_AbstractTRCProcess", //AbstractTRCProcess
		/*4*/	"5","Hierarchy_AbstractTRCView", //AbstractTRCView
		/*5*/	"6","Hierarchy_Extensions_ArithmeticExpression", //ArithmeticExpression
		/*6*/	"81","Common_Fragments_BVRCombinedFragment", //BVRCombinedFragment
		/*7*/	"82","Common_Interactions_BVREventOccurrence", //BVREventOccurrence
		/*8*/	"83","Common_Interactions_BVRExecutionOccurrence", //BVRExecutionOccurrence
		/*9*/	"84","Common_Fragments_BVRGate", //BVRGate
		/*10*/	"85","Common_Interactions_BVRGeneralOrdering", //BVRGeneralOrdering
		/*11*/	"86","Common_Fragments_BVRInteraction", //BVRInteraction
		/*12*/	"87","Common_Fragments_BVRInteractionConstraint", //BVRInteractionConstraint
		/*13*/	"88","Common_Interactions_BVRInteractionFragment", //BVRInteractionFragment
		/*14*/	"89","Common_Fragments_BVRInteractionOccurrence", //BVRInteractionOccurrence
		/*15*/	"90","Common_Fragments_BVRInteractionOperand", //BVRInteractionOperand
		/*16*/	"91","Common_Interactions_BVRLifeline", //BVRLifeline
		/*17*/	"92","Common_Interactions_BVRMessage", //BVRMessage
		/*18*/	"93","Common_Interactions_BVRMessageEnd", //BVRMessageEnd
		/*19*/	"94","Common_Fragments_BVRPartDecomposition", //BVRPartDecomposition
		/*20*/	"95","Common_Interactions_BVRProperty", //BVRProperty
		/*21*/	"96","Common_Interactions_BVRStateInvariant", //BVRStateInvariant
		/*22*/	"97","Common_Interactions_BVRStop", //BVRStop
		/*23*/	"7","Hierarchy_Extensions_BinaryExpression", //BinaryExpression
		/*24*/	"8","Cbe_CBEAvailableSituation", //CBEAvailableSituation
		/*25*/	"9","Cbe_CBECommonBaseEvent", //CBECommonBaseEvent
		/*26*/	"10","Cbe_CBEComponentIdentification", //CBEComponentIdentification
		/*27*/	"11","Cbe_CBEConfigureSituation", //CBEConfigureSituation
		/*28*/	"12","Cbe_CBEConnectSituation", //CBEConnectSituation
		/*29*/	"13","Cbe_CBEContextDataElement", //CBEContextDataElement
		/*30*/	"14","Cbe_CBECreateSituation", //CBECreateSituation
		/*31*/	"15","Cbe_CBEDefaultElement", //CBEDefaultElement
		/*32*/	"16","Cbe_CBEDefaultEvent", //CBEDefaultEvent
		/*33*/	"17","Cbe_CBEDependencySituation", //CBEDependencySituation
		/*34*/	"18","Cbe_CBEDestroySituation", //CBEDestroySituation
		/*35*/	"19","Cbe_CBEExtendedDataElement", //CBEExtendedDataElement
		/*36*/	"20","Cbe_CBEFeatureSituation", //CBEFeatureSituation
		/*37*/	"21","Cbe_CBEMsgDataElement", //CBEMsgDataElement
		/*38*/	"22","Cbe_CBEOtherSituation", //CBEOtherSituation
		/*39*/	"23","Cbe_CBEReportSituation", //CBEReportSituation
		/*40*/	"24","Cbe_CBERequestSituation", //CBERequestSituation
		/*41*/	"25","Cbe_CBESituation", //CBESituation
		/*42*/	"26","Cbe_CBEStartSituation", //CBEStartSituation
		/*43*/	"27","Cbe_CBEStopSituation", //CBEStopSituation
		/*44*/	"98","Common_Configuration_CFGArtifact", //CFGArtifact
		/*45*/	"99","Common_Configuration_CFGArtifactLocationPair", //CFGArtifactLocationPair
		/*46*/	"100","Common_Configuration_CFGCategory", //CFGCategory
		/*47*/	"101","Common_Configuration_CFGClass", //CFGClass
		/*48*/	"102","Common_Configuration_CFGComparableProperty", //CFGComparableProperty
		/*49*/	"103","Common_Configuration_CFGConfigurableObject", //CFGConfigurableObject
		/*50*/	"104","Common_Configuration_CFGInstance", //CFGInstance
		/*51*/	"105","Common_Configuration_CFGLocation", //CFGLocation
		/*52*/	"106","Common_Configuration_CFGMachine", //CFGMachine
		/*53*/	"107","Common_Configuration_CFGMachineConstraint", //CFGMachineConstraint
		/*54*/	"108","Common_Configuration_CFGMachineInstance", //CFGMachineInstance
		/*55*/	"109","Common_Configuration_CFGOperation", //CFGOperation
		/*56*/	"110","Common_Configuration_CFGPropertyGroup", //CFGPropertyGroup
		/*57*/	"111","Common_Configuration_CFGPsudoEnumeration", //CFGPsudoEnumeration
		/*58*/	"112","Common_CMNAnnotation", //CMNAnnotation
		/*59*/	"113","Common_CMNDefaultProperty", //CMNDefaultProperty
		/*60*/	"114","Common_CMNExtendedProperty", //CMNExtendedProperty
		/*61*/	"115","Common_CMNMachine", //CMNMachine
		/*62*/	"116","Common_CMNNamedElement", //CMNNamedElement
		/*63*/	"117","Common_CMNNodeInstance", //CMNNodeInstance
		/*64*/	"118","Common_CMNNodeType", //CMNNodeType
		/*65*/	"28","Hierarchy_CorrelationContainer", //CorrelationContainer
		/*66*/	"29","Hierarchy_CorrelationContainerProxy", //CorrelationContainerProxy
		/*67*/	"30","Hierarchy_CorrelationEngine", //CorrelationEngine
		/*68*/	"31","Hierarchy_CorrelationEntry", //CorrelationEntry
		/*69*/	"32","Hierarchy_Extensions_CorrelationQuery", //CorrelationQuery
		/*70*/	"33","Hierarchy_CorrelationSourceInfo", //CorrelationSourceInfo
		/*71*/	"119","Common_Datapool_DPLCell", //DPLCell
		/*72*/	"120","Common_Datapool_DPLDatapool", //DPLDatapool
		/*73*/	"121","Common_Datapool_DPLDatapoolSpec", //DPLDatapoolSpec
		/*74*/	"122","Common_Datapool_DPLEquivalenceClass", //DPLEquivalenceClass
		/*75*/	"123","Common_Datapool_DPLRecord", //DPLRecord
		/*76*/	"124","Common_Datapool_DPLVariable", //DPLVariable
		/*77*/	"34","Ecore_EAnnotation", //EAnnotation
		/*78*/	"35","Ecore_EAttribute", //EAttribute
		/*79*/	"36","Ecore_EClass", //EClass
		/*80*/	"37","Ecore_EClassifier", //EClassifier
		/*81*/	"38","Ecore_EDataType", //EDataType
		/*82*/	"39","Ecore_EEnum", //EEnum
		/*83*/	"40","Ecore_EEnumLiteral", //EEnumLiteral
		/*84*/	"41","Ecore_EFactory", //EFactory
		/*85*/	"42","Ecore_EModelElement", //EModelElement
		/*86*/	"43","Ecore_ENamedElement", //ENamedElement
		/*87*/	"44","Ecore_EObject", //EObject
		/*88*/	"125","Common_Testprofile_EObjectReference", //EObjectReference
		/*89*/	"45","Ecore_EOperation", //EOperation
		/*90*/	"46","Ecore_EPackage", //EPackage
		/*91*/	"47","Ecore_EParameter", //EParameter
		/*92*/	"48","Ecore_EReference", //EReference
		/*93*/	"49","Ecore_EStringToStringMapEntry", //EStringToStringMapEntry
		/*94*/	"50","Ecore_EStructuralFeature", //EStructuralFeature
		/*95*/	"51","Ecore_ETypedElement", //ETypedElement
		/*96*/	"126","Common_Configuration_HyadesBrowserEnumeration", //HyadesBrowserEnumeration
		/*97*/	"127","Common_Configuration_HyadesBrowserTypeCategory", //HyadesBrowserTypeCategory
		/*98*/	"128","Common_Configuration_HyadesBrowserVersionCategory", //HyadesBrowserVersionCategory
		/*99*/	"129","Common_Configuration_HyadesClasspathCategory", //HyadesClasspathCategory
		/*100*/	"130","Common_Configuration_HyadesDatabaseCategory", //HyadesDatabaseCategory
		/*101*/	"131","Common_Configuration_HyadesDatabaseEnumeration", //HyadesDatabaseEnumeration
		/*102*/	"132","Common_Configuration_HyadesDatabaseVersionCategory", //HyadesDatabaseVersionCategory
		/*103*/	"133","Common_Configuration_HyadesDisplayColorDepthCategory", //HyadesDisplayColorDepthCategory
		/*104*/	"134","Common_Configuration_HyadesDisplayColorDepthEnumeration", //HyadesDisplayColorDepthEnumeration
		/*105*/	"135","Common_Configuration_HyadesDisplayHeightCategory", //HyadesDisplayHeightCategory
		/*106*/	"136","Common_Configuration_HyadesDisplayHeightEnumeration", //HyadesDisplayHeightEnumeration
		/*107*/	"137","Common_Configuration_HyadesDisplayNumberCategory", //HyadesDisplayNumberCategory
		/*108*/	"138","Common_Configuration_HyadesDisplayWidthCategory", //HyadesDisplayWidthCategory
		/*109*/	"139","Common_Configuration_HyadesDisplayWidthEnumeration", //HyadesDisplayWidthEnumeration
		/*110*/	"140","Common_Configuration_HyadesHostnameCategory", //HyadesHostnameCategory
		/*111*/	"141","Common_Configuration_HyadesMajorVersionCategory", //HyadesMajorVersionCategory
		/*112*/	"142","Common_Configuration_HyadesMemorySizeCategory", //HyadesMemorySizeCategory
		/*113*/	"143","Common_Configuration_HyadesMinorVersionCategory", //HyadesMinorVersionCategory
		/*114*/	"144","Common_Configuration_HyadesOperatingSystemCategory", //HyadesOperatingSystemCategory
		/*115*/	"145","Common_Configuration_HyadesOperatingSystemEnumeration", //HyadesOperatingSystemEnumeration
		/*116*/	"146","Common_Configuration_HyadesPasswordCategory", //HyadesPasswordCategory
		/*117*/	"147","Common_Configuration_HyadesProcessorNumberCategory", //HyadesProcessorNumberCategory
		/*118*/	"148","Common_Configuration_HyadesProcessorSpeedCategory", //HyadesProcessorSpeedCategory
		/*119*/	"149","Common_Configuration_HyadesProcessorTypeCategory", //HyadesProcessorTypeCategory
		/*120*/	"150","Common_Configuration_HyadesProcessorTypeEnumeration", //HyadesProcessorTypeEnumeration
		/*121*/	"151","Common_Configuration_HyadesRootDirectroyCategory", //HyadesRootDirectroyCategory
		/*122*/	"152","Common_Configuration_HyadesServicePackCategory", //HyadesServicePackCategory
		/*123*/	"153","Common_Configuration_HyadesServicePackEnumeration", //HyadesServicePackEnumeration
		/*124*/	"154","Common_Configuration_HyadesUsernameCategory", //HyadesUsernameCategory
		/*125*/	"155","Common_Configuration_HyadesWindowsDomainCategory", //HyadesWindowsDomainCategory
		/*126*/	"156","Common_Testprofile_ITPFExtendedVerdictReason", //ITPFExtendedVerdictReason
		/*127*/	"52","Hierarchy_Extensions_InstanceQuery", //InstanceQuery
		/*128*/	"53","Hierarchy_Extensions_LogicalExpression", //LogicalExpression
		/*129*/	"54","Hierarchy_Extensions_NumericFunction", //NumericFunction
		/*130*/	"55","Hierarchy_Extensions_Operand", //Operand
		/*131*/	"56","Hierarchy_Extensions_OrderByElement", //OrderByElement
		/*132*/	"57","Hierarchy_Extensions_Query", //Query
		/*133*/	"58","Hierarchy_Extensions_QueryResult", //QueryResult
		/*134*/	"59","Hierarchy_Extensions_ResultEntry", //ResultEntry
		/*135*/	"60","Sdb_SDBDirective", //SDBDirective
		/*136*/	"61","Sdb_SDBMatchPattern", //SDBMatchPattern
		/*137*/	"62","Sdb_SDBRuntime", //SDBRuntime
		/*138*/	"63","Sdb_SDBSolution", //SDBSolution
		/*139*/	"64","Sdb_SDBSymptom", //SDBSymptom
		/*140*/	"157","Statistical_SDContiguousObservation", //SDContiguousObservation
		/*141*/	"158","Statistical_SDContiguousRepresentation", //SDContiguousRepresentation
		/*142*/	"159","Statistical_SDCounterDescriptor", //SDCounterDescriptor
		/*143*/	"160","Statistical_SDDescriptor", //SDDescriptor
		/*144*/	"161","Statistical_SDDiscreteObservation", //SDDiscreteObservation
		/*145*/	"162","Statistical_SDDiscreteRepresentation", //SDDiscreteRepresentation
		/*146*/	"163","Statistical_SDGaugeRepresentation", //SDGaugeRepresentation
		/*147*/	"164","Statistical_SDMemberDescriptor", //SDMemberDescriptor
		/*148*/	"165","Statistical_SDRangeRepresentation", //SDRangeRepresentation
		/*149*/	"166","Statistical_SDRepresentation", //SDRepresentation
		/*150*/	"167","Statistical_SDSampleDescriptor", //SDSampleDescriptor
		/*151*/	"168","Statistical_SDSampleWindow", //SDSampleWindow
		/*152*/	"169","Statistical_SDSnapshotObservation", //SDSnapshotObservation
		/*153*/	"170","Statistical_SDTextObservation", //SDTextObservation
		/*154*/	"171","Statistical_SDTextRepresentation", //SDTextRepresentation
		/*155*/	"172","Statistical_SDView", //SDView
		/*156*/	"65","Hierarchy_Extensions_SimpleOperand", //SimpleOperand
		/*157*/	"66","Hierarchy_Extensions_SimpleSearchQuery", //SimpleSearchQuery
		/*158*/	"173","Common_Testprofile_TPFArbiter", //TPFArbiter
		/*159*/	"174","Common_Testprofile_TPFBehavior", //TPFBehavior
		/*160*/	"175","Common_Testprofile_TPFCodingRule", //TPFCodingRule
		/*161*/	"176","Common_Testprofile_TPFDefault", //TPFDefault
		/*162*/	"177","Common_Testprofile_TPFDefaultApplication", //TPFDefaultApplication
		/*163*/	"178","Common_Testprofile_TPFDeployment", //TPFDeployment
		/*164*/	"179","Common_Testprofile_TPFExecutionEvent", //TPFExecutionEvent
		/*165*/	"180","Common_Testprofile_TPFExecutionHistory", //TPFExecutionHistory
		/*166*/	"181","Common_Testprofile_TPFExecutionResult", //TPFExecutionResult
		/*167*/	"182","Common_Testprofile_TPFExecutionStatus", //TPFExecutionStatus
		/*168*/	"183","Common_Testprofile_TPFExtendedReasonToVerdictMapEntry", //TPFExtendedReasonToVerdictMapEntry
		/*169*/	"184","Common_Testprofile_TPFInstanceValue", //TPFInstanceValue
		/*170*/	"185","Common_Testprofile_TPFInvocationEvent", //TPFInvocationEvent
		/*171*/	"186","Common_Testprofile_TPFLiteralAny", //TPFLiteralAny
		/*172*/	"187","Common_Testprofile_TPFLiteralAnyorNull", //TPFLiteralAnyorNull
		/*173*/	"188","Common_Testprofile_TPFLogAction", //TPFLogAction
		/*174*/	"189","Common_Testprofile_TPFLoopEvent", //TPFLoopEvent
		/*175*/	"190","Common_Testprofile_TPFMessageEvent", //TPFMessageEvent
		/*176*/	"191","Common_Testprofile_TPFReasonToVerdictMapEntry", //TPFReasonToVerdictMapEntry
		/*177*/	"192","Common_Testprofile_TPFRepositoryRecord", //TPFRepositoryRecord
		/*178*/	"193","Common_Testprofile_TPFSUT", //TPFSUT
		/*179*/	"194","Common_Testprofile_TPFTest", //TPFTest
		/*180*/	"195","Common_Testprofile_TPFTestCase", //TPFTestCase
		/*181*/	"196","Common_Testprofile_TPFTestComponent", //TPFTestComponent
		/*182*/	"197","Common_Testprofile_TPFTestObjective", //TPFTestObjective
		/*183*/	"198","Common_Testprofile_TPFTestSuite", //TPFTestSuite
		/*184*/	"199","Common_Testprofile_TPFTimedEvent", //TPFTimedEvent
		/*185*/	"200","Common_Testprofile_TPFTimezone", //TPFTimezone
		/*186*/	"201","Common_Testprofile_TPFTypedEvent", //TPFTypedEvent
		/*187*/	"202","Common_Testprofile_TPFValidationAction", //TPFValidationAction
		/*188*/	"203","Common_Testprofile_TPFVerdictEvent", //TPFVerdictEvent
		/*189*/	"204","Common_Testprofile_TPFVerdictList", //TPFVerdictList
		/*190*/	"205","Common_Testprofile_TPFWaitEvent", //TPFWaitEvent
		/*191*/	"67","Hierarchy_TRCAgent", //TRCAgent
		/*192*/	"68","Hierarchy_TRCAgentProxy", //TRCAgentProxy
		/*193*/	"206","Trace_TRCAggregatedMethodInvocation", //TRCAggregatedMethodInvocation
		/*194*/	"207","Trace_TRCAggregatedObjectReference", //TRCAggregatedObjectReference
		/*195*/	"69","Hierarchy_TRCAnnotation", //TRCAnnotation
		/*196*/	"208","Trace_TRCArrayClass", //TRCArrayClass
		/*197*/	"209","Trace_TRCCallerCalleeInvocationInfo", //TRCCallerCalleeInvocationInfo
		/*198*/	"210","Trace_TRCClass", //TRCClass
		/*199*/	"211","Trace_TRCClassLoader", //TRCClassLoader
		/*200*/	"212","Trace_TRCCollectionBoundary", //TRCCollectionBoundary
		/*201*/	"70","Hierarchy_TRCConfiguration", //TRCConfiguration
		/*202*/	"71","Hierarchy_TRCEnvironmentVariable", //TRCEnvironmentVariable
		/*203*/	"72","Hierarchy_TRCExecParameter", //TRCExecParameter
		/*204*/	"73","Hierarchy_TRCFilter", //TRCFilter
		/*205*/	"213","Trace_TRCFullHeapObject", //TRCFullHeapObject
		/*206*/	"214","Trace_TRCFullMethodInvocation", //TRCFullMethodInvocation
		/*207*/	"215","Trace_TRCFullTraceObject", //TRCFullTraceObject
		/*208*/	"216","Trace_TRCGCEvent", //TRCGCEvent
		/*209*/	"217","Trace_TRCHeapDump", //TRCHeapDump
		/*210*/	"218","Trace_TRCHeapObject", //TRCHeapObject
		/*211*/	"219","Trace_TRCHeapRoot", //TRCHeapRoot
		/*212*/	"220","Trace_TRCInputOutputContainer", //TRCInputOutputContainer
		/*213*/	"221","Trace_TRCInputOutputEntry", //TRCInputOutputEntry
		/*214*/	"222","Trace_TRCLLData", //TRCLLData
		/*215*/	"223","Trace_TRCLanguageElement", //TRCLanguageElement
		/*216*/	"224","Trace_TRCLineCoverageData", //TRCLineCoverageData
		/*217*/	"225","Trace_TRCLinePerformanceData", //TRCLinePerformanceData
		/*218*/	"226","Trace_TRCLockAccess", //TRCLockAccess
		/*219*/	"227","Trace_TRCMethod", //TRCMethod
		/*220*/	"228","Trace_TRCMethodInvocation", //TRCMethodInvocation
		/*221*/	"229","Trace_TRCMethodWithLLData", //TRCMethodWithLLData
		/*222*/	"74","Hierarchy_TRCMonitor", //TRCMonitor
		/*223*/	"230","Trace_TRCMthdLckAccEntry", //TRCMthdLckAccEntry
		/*224*/	"75","Hierarchy_TRCNode", //TRCNode
		/*225*/	"231","Trace_TRCObject", //TRCObject
		/*226*/	"232","Trace_TRCObjectAllocationAnnotation", //TRCObjectAllocationAnnotation
		/*227*/	"233","Trace_TRCObjectAllocationSite", //TRCObjectAllocationSite
		/*228*/	"234","Trace_TRCObjectAllocationSitesEntry", //TRCObjectAllocationSitesEntry
		/*229*/	"235","Trace_TRCObjectReference", //TRCObjectReference
		/*230*/	"236","Trace_TRCObjectValue", //TRCObjectValue
		/*231*/	"76","Hierarchy_TRCOption", //TRCOption
		/*232*/	"237","Trace_TRCPackage", //TRCPackage
		/*233*/	"238","Trace_TRCProcess", //TRCProcess
		/*234*/	"77","Hierarchy_TRCProcessProxy", //TRCProcessProxy
		/*235*/	"239","Trace_TRCSourceInfo", //TRCSourceInfo
		/*236*/	"240","Trace_TRCSourceInfoWithLLData", //TRCSourceInfoWithLLData
		/*237*/	"241","Trace_TRCThread", //TRCThread
		/*238*/	"242","Trace_TRCThreadDeadEvent", //TRCThreadDeadEvent
		/*239*/	"243","Trace_TRCThreadDeadLockEvent", //TRCThreadDeadLockEvent
		/*240*/	"244","Trace_TRCThreadEvent", //TRCThreadEvent
		/*241*/	"245","Trace_TRCThreadRunningEvent", //TRCThreadRunningEvent
		/*242*/	"246","Trace_TRCThreadSleepingEvent", //TRCThreadSleepingEvent
		/*243*/	"247","Trace_TRCThreadWaitingForLockEvent", //TRCThreadWaitingForLockEvent
		/*244*/	"248","Trace_TRCThreadWaitingForObjectEvent", //TRCThreadWaitingForObjectEvent
		/*245*/	"249","Trace_TRCTraceObject", //TRCTraceObject
		/*246*/	"250","Trace_TRCTypedObjectValue", //TRCTypedObjectValue
		/*247*/	"78","Hierarchy_Extensions_TimeBasedCorrelationQuery", //TimeBasedCorrelationQuery
		/*248*/	"79","Hierarchy_UnresolvedCorrelation", //UnresolvedCorrelation
		/*249*/	"80","Hierarchy_Extensions_WhereExpression", //WhereExpression
	};
	
	public static HyadesResourceExtensions getInstance(Properties prop){
		if (instance == null) {
			instance = new HyadesResourceExtensions();
			instance.initClassIdMap();
			instance.allProperties = new HashMap();
			new HyadesResourceRegistryReader().readRegistry();
			String activeDBType = prop.getProperty("largeResourceSupportStoreType");
			if (activeDBType != null){
				for (Iterator iter = instance.entrySet().iterator(); iter.hasNext();) {
					Map.Entry element = (Map.Entry) iter.next();
					IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension) element.getValue();
					if (activeDBType.equals(hyadesResourceFactory.getStoreType((String) element.getKey()))) {
						instance.defaultHyadesResourceFactory = hyadesResourceFactory;
						instance.setProperties(activeDBType,prop);
						break;
					}
				}
			}
		}
		return instance;
	}
	public static HyadesResourceExtensions getInstance() {
		if (instance == null) {
			instance = new HyadesResourceExtensions();
			instance.initClassIdMap();
			instance.allProperties = new HashMap();
			new HyadesResourceRegistryReader().readRegistry();
			try {
				Preferences preferences = ModelsHierarchyPlugin.getPlugin().getPluginPreferences();
				for (Iterator iter = instance.entrySet().iterator(); iter.hasNext();) {
					Map.Entry element = (Map.Entry) iter.next();
					IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension) element.getValue();
					if (instance.defaultHyadesResourceFactory == null && preferences.getString(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE).equals(hyadesResourceFactory.getStoreType((String) element.getKey()))) {
						String defaultStoreTypeName = preferences.getString(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE);
						instance.defaultHyadesResourceFactory = hyadesResourceFactory;
						instance.defaultProperties.setProperty("location", preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_LOCATION));
						instance.defaultProperties.setProperty("user", preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_USERNAME));
						instance.defaultProperties.setProperty("password", LoadersUtils.restorePassword(preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_PASSWORD)));
//						instance.defaultProperties.setProperty("cacheSize", preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_CACHE_SIZE));
						instance.defaultProperties.setProperty("largeResourceSupportStoreType", defaultStoreTypeName);
						try {
							instance.defaultProperties.setProperty("largeResourceSupportJDBCLocation",new File(preferences.getString(defaultStoreTypeName+"/"+"largeResourceSupportJDBCLocation")).toURL().toString());
						} catch (MalformedURLException e) {
						}
						
						Properties p = instance.getProperties(defaultStoreTypeName);
						if(p == null)
						{
							p = new Properties();
							instance.setProperties(defaultStoreTypeName,p);
						}
						p.setProperty("location", preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_LOCATION));
						p.setProperty("user", preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_USERNAME));
						p.setProperty("password", LoadersUtils.restorePassword(preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_PASSWORD)));
//						p.setProperty("cacheSize", preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_CACHE_SIZE));
						p.setProperty("largeResourceSupportStoreType", defaultStoreTypeName);
						try {
							p.setProperty("largeResourceSupportJDBCLocation",new File(preferences.getString(defaultStoreTypeName+"/"+"largeResourceSupportJDBCLocation")).toURL().toString());
						} catch (MalformedURLException e) {
						}
					}
				}
			} catch (Exception e) {
				// TODO: MS add support for standalone mode
			}
		}
		return instance;
	}

	protected void initClassIdMap() {
		classIdMap=new ObjectToIntMapImpl(classIdArray.length/2);
		for (int i = 0; i < classIdArray.length; i=i+2) {
			classIdMap.put(classIdArray[i+1], Integer.parseInt(classIdArray[i]));
		}
	}
	//	public Resource createResource(URI uri) {
//		IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension) getInstance().get(LoadersUtils.getPostfix(uri));
//		if (hyadesResourceExtension == null)
//			return null;
//		return hyadesResourceExtension.createResource(uri, defaultProperties);
//	}
	public Resource createResource(URI uri, Properties p) {
		IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension) getInstance().get(LoadersUtils.getPostfix(uri));
		if (hyadesResourceExtension == null)
			return null;
		return hyadesResourceExtension.createResource(uri, p);
	}
	public Resource createResource(URI uri, Properties p, Collection notLoaded) {
		IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension) getInstance().get(LoadersUtils.getPostfix(uri));
		if (hyadesResourceExtension == null)
			return null;
		return hyadesResourceExtension.createResource(uri, p,notLoaded);
	}
	public EList createList(Class dataClass, InternalEObject owner, int featureID, int inverseFeatureID) {
		IHyadesResourceExtension hyadesResourceFactory = getHyadesResourceFactory(owner);
		if (hyadesResourceFactory == null)
			return null;
		return hyadesResourceFactory.createPagingList(dataClass, owner, featureID, inverseFeatureID);
	}
	public EList createList(Class dataClass, InternalEObject owner, int featureID) {
		IHyadesResourceExtension hyadesResourceFactory = getHyadesResourceFactory(owner);
		if (hyadesResourceFactory == null)
			return null;
		return hyadesResourceFactory.createPagingList(dataClass, owner, featureID);
	}
	public EList createList(InternalEObject owner, EStructuralFeature feature) {
		IHyadesResourceExtension hyadesResourceFactory = getHyadesResourceFactory(owner);
		if (hyadesResourceFactory == null)
			return null;
		return hyadesResourceFactory.createPagingList(owner, feature);
	}
	/**
	 * @param owner
	 * @return
	 */
	protected IHyadesResourceExtension getHyadesResourceFactory(InternalEObject owner) {
		Resource resource = owner.eResource();
		if (resource == null) {
			if (defaultHyadesResourceFactory != null) {
				return defaultHyadesResourceFactory;
			}
			return null;
		}
		URI uri = resource.getURI();
		if (uri == null)
			return null;
		IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension) getInstance().get(LoadersUtils.getPostfix(uri));
		return hyadesResourceFactory;
	}
	/**
	 * @param uri
	 * @param notLoaded
	 * @return
	 */
	public Resource createResource(URI uri, Collection notLoaded) {
		IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension) getInstance().get(LoadersUtils.getPostfix(uri));
		if (hyadesResourceExtension == null)
			return null;
		Properties p = (Properties)allProperties.get(hyadesResourceExtension.getStoreType(LoadersUtils.getPostfix(uri)));
		if(p==null)
		{
			p = defaultProperties;
		}
		return hyadesResourceExtension.createResource(uri, p, notLoaded);
	}
	/**
	 * @return Returns the properties.
	 */
	public Properties getProperties() {
		return defaultProperties;
	}
	public Properties getProperties(String key) {
		return (Properties)allProperties.get(key);
	}
	public void setProperties(String key,Properties properties) {
		allProperties.put(key,properties);
	}
	public Map getAllProperties() {
		return allProperties;
	}
	public ObjectToIntMap getClassIdMap() {
		return classIdMap;
	}
	
	/**
	 * Compute a name for the class, including the appropriate number of package
	 * names.
	 */
	public String getName(EClass eClass, int packageNumber) {
		String name = eClass.getName();
		EPackage ePackage = eClass.getEPackage();

		while (ePackage != null && packageNumber > 0) {
			String pkgName = ePackage.getName();
			pkgName = upperCaseFirst(pkgName);
			name = pkgName + "_" + name;
			--packageNumber;
			ePackage = ePackage.getESuperPackage();
		}

		return name;
	}
	public String upperCaseFirst(String name) {
		return name.substring(0, 1).toUpperCase() + name.substring(1);
	}
}
/**
 * A plugin extension reader that populates the loaders registry. Clients are
 * not expected to use this class directly.
 */
class HyadesResourceRegistryReader extends RegistryReader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	static final String TAG_RESOURCE_EXTENSION = "hyadesResourceExtension";
	//~ Constructors
	// -------------------------------------------------------------------------------
	public HyadesResourceRegistryReader() {
		super(RegistryReader.HYADES_RESOURCE_EXTENSION_PPID);
	}
	//~ Methods
	// ------------------------------------------------------------------------------------
	protected boolean readElement(HyadesConfigurationElement element) {
		if (element.getName().equals(TAG_RESOURCE_EXTENSION)) {
			//			String filePostfix = element.getAttribute(ATT_FILE_POSTFIX);
			//			if (filePostfix == null) {
			//				logMissingAttribute(element, ATT_FILE_POSTFIX);
			//			}else
			if (element.getAttribute(ATT_CLASS) == null) {
				logMissingAttribute(element, ATT_CLASS);
			} else {
				try {
                	float priority = 0;
                    if (element.getAttribute(ATT_PRIORITY) != null) {
                    	priority = Float.parseFloat(element.getAttribute(ATT_PRIORITY));
                    }

					IHyadesPluginClassDescriptor classDescriptor = createPluginClassDescriptor(element, ATT_CLASS);
					IHyadesResourceExtension f = (IHyadesResourceExtension) classDescriptor.createInstance();
					List postfixes = f.getSupportedPostfixes();
					for (Iterator iter = postfixes.iterator(); iter.hasNext();) {
						String postfix = (String) iter.next();
						if (HyadesResourceExtensions.getInstance().containsKey(postfix) && ((Float)getPriorities().get(postfix)).floatValue() >= priority) {
							if(ModelDebugger.INSTANCE.debug)
								logError(element, "A Hyades resource factory extension for this \"" + postfix + "\" with higher or equal priority already exists, this extension will be ignored.");
						} else {
							HyadesResourceExtensions.getInstance().put(postfix, f);
							getPriorities().put(postfix, new Float(priority));
						}
					}
				} catch (Exception e) {
					logError(element, e.getLocalizedMessage());
				}
				return true;
			}
		}
		return false;
	}
}