/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPagingList.java,v 1.2 2007/12/01 00:06:18 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.util;

import org.eclipse.emf.common.util.EList;

/**
 * @author slavescu
 */
public interface IPagingList extends EList {
	public int indexOf(Object object,int fromIndex);
	public int lastIndexOf(Object object, int fromIndex);
	/**
	 * @return The index (starting with fromIndex) of the object with internal ID equal with internalId
	 */
	public int indexOf(String internalId,int fromIndex);
	/**
	 * @return The last index (starting with fromIndex) of the object with internal ID equal with internalId
	 */
	public int lastIndexOf(String internalId, int fromIndex);
	/**
	 * @return The internal ID of the object, this internalId can then be used to do optimized indexOf/lastIndexOf
	 */
	public String getInternalId(Object object);
	/**
	 * @return The internal ID of the object at index index, this internalId can then be used to do optimized indexOf/lastIndexOf
	 */
	public String getInternalId(int index);

}
