/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LookupService.java,v 1.2 2007/12/01 00:06:18 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.Set;


/**
 * @author slavescu
 */
public interface LookupService {
    //~ Methods ------------------------------------------------------------------------------------

    Set getSupportedTypes();

    boolean deregister(HierarchyContext context, Class type, Object key);

    boolean deregister(HierarchyContext context, Object value);

	boolean deregister(HierarchyContext context, Class type);

	boolean deregister(HierarchyContext context);

    Object locate(HierarchyContext context, Object key);

    Object locate(HierarchyContext context, Class type, Object key);

    boolean register(HierarchyContext context, Object value);
}
