/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BinaryExpression.java,v 1.3 2009/05/05 15:45:27 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Binary Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Binary expressions which might have multiple rigth operands (e.g. IN and BETWEEN)
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getOperator <em>Operator</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getLeftOperand <em>Left Operand</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getRightOperands <em>Right Operands</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#isCaseInsensitive <em>Case Insensitive</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getInstanceQuery <em>Instance Query</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getBinaryExpression()
 * @model
 * @generated
 */
public interface BinaryExpression extends WhereExpression {
	/**
	 * Returns the value of the '<em><b>Operator</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operator</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operator</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators
	 * @see #setOperator(RelationalOperators)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getBinaryExpression_Operator()
	 * @model
	 * @generated
	 */
	RelationalOperators getOperator();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getOperator <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operator</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators
	 * @see #getOperator()
	 * @generated
	 */
	void setOperator(RelationalOperators value);

	/**
	 * Returns the value of the '<em><b>Left Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Left Operand</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Left Operand</em>' containment reference.
	 * @see #setLeftOperand(Operand)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getBinaryExpression_LeftOperand()
	 * @model containment="true"
	 * @generated
	 */
	Operand getLeftOperand();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getLeftOperand <em>Left Operand</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Left Operand</em>' containment reference.
	 * @see #getLeftOperand()
	 * @generated
	 */
	void setLeftOperand(Operand value);

	/**
	 * Returns the value of the '<em><b>Right Operands</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.extensions.Operand}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Right Operands</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is a list because we can have one or many operatand in expresions with IN or BETWEEN operators
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Right Operands</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getBinaryExpression_RightOperands()
	 * @model containment="true"
	 * @generated
	 */
	EList<Operand> getRightOperands();

	/**
	 * Returns the value of the '<em><b>Case Insensitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If true the operand's value is treated as beeing case insensitive. Default is false.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Case Insensitive</em>' attribute.
	 * @see #setCaseInsensitive(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getBinaryExpression_CaseInsensitive()
	 * @model
	 * @generated
	 */
	boolean isCaseInsensitive();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#isCaseInsensitive <em>Case Insensitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Case Insensitive</em>' attribute.
	 * @see #isCaseInsensitive()
	 * @generated
	 */
	void setCaseInsensitive(boolean value);

	/**
	 * Returns the value of the '<em><b>Instance Query</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instance Query</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instance Query</em>' container reference.
	 * @see #setInstanceQuery(InstanceQuery)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getBinaryExpression_InstanceQuery()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery#getConditions
	 * @model opposite="conditions" required="true"
	 * @generated
	 */
	InstanceQuery getInstanceQuery();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getInstanceQuery <em>Instance Query</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Instance Query</em>' container reference.
	 * @see #getInstanceQuery()
	 * @generated
	 */
	void setInstanceQuery(InstanceQuery value);

} // BinaryExpression
