/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: Query.java,v 1.3 2009/05/05 15:45:27 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Query</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getSources <em>Sources</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isDistinct <em>Distinct</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isCount <em>Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getOutputElements <em>Output Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getSubQuery <em>Sub Query</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery <em>Query</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getRequiredPaths <em>Required Paths</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getAnnotations <em>Annotations</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery()
 * @model abstract="true"
 * @generated
 */
public interface Query extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Sources</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Points to a list of resource URIs, starting EObject URIs or Query names
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Sources</em>' attribute list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Sources()
	 * @model
	 * @generated
	 */
	EList<String> getSources();

	/**
	 * Returns the value of the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Distinct</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Distinct</em>' attribute.
	 * @see #setDistinct(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Distinct()
	 * @model
	 * @generated
	 */
	boolean isDistinct();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isDistinct <em>Distinct</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Distinct</em>' attribute.
	 * @see #isDistinct()
	 * @generated
	 */
	void setDistinct(boolean value);

	/**
	 * Returns the value of the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Count</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Count</em>' attribute.
	 * @see #setCount(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Count()
	 * @model
	 * @generated
	 */
	boolean isCount();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isCount <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Count</em>' attribute.
	 * @see #isCount()
	 * @generated
	 */
	void setCount(boolean value);

	/**
	 * Returns the value of the '<em><b>Output Elements</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.extensions.Operand}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.Operand#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Output Elements</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Output Elements</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_OutputElements()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Operand#getQuery
	 * @model opposite="query" containment="true"
	 * @generated
	 */
	EList<Operand> getOutputElements();

	/**
	 * Returns the value of the '<em><b>Sub Query</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.extensions.Query}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sub Query</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sub Query</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_SubQuery()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery
	 * @model opposite="query" containment="true"
	 * @generated
	 */
	EList<Query> getSubQuery();

	/**
	 * Returns the value of the '<em><b>Query</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getSubQuery <em>Sub Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Query</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Query</em>' container reference.
	 * @see #setQuery(Query)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Query()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getSubQuery
	 * @model opposite="subQuery"
	 * @generated
	 */
	Query getQuery();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery <em>Query</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Query</em>' container reference.
	 * @see #getQuery()
	 * @generated
	 */
	void setQuery(Query value);

	/**
	 * Returns the value of the '<em><b>Required Paths</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.EStructuralFeature}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Required Paths</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Required Paths</em>' reference list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_RequiredPaths()
	 * @model
	 * @generated
	 */
	EList<EStructuralFeature> getRequiredPaths();

	/**
	 * Returns the value of the '<em><b>Annotations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.TRCAnnotation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Annotations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Annotations</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Annotations()
	 * @model containment="true"
	 * @generated
	 */
	EList<TRCAnnotation> getAnnotations();

} // Query
