/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CorrelationQueryImpl.java,v 1.3 2009/05/05 15:45:26 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Correlation Query</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl#getCorrelationContainerURI <em>Correlation Container URI</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl#getCorrelationContainerProxyURI <em>Correlation Container Proxy URI</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl#getDeltaTime <em>Delta Time</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CorrelationQueryImpl extends SimpleSearchQueryImpl implements CorrelationQuery {
	/**
	 * The default value of the '{@link #getCorrelationContainerURI() <em>Correlation Container URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationContainerURI()
	 * @generated
	 * @ordered
	 */
	protected static final String CORRELATION_CONTAINER_URI_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCorrelationContainerURI() <em>Correlation Container URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationContainerURI()
	 * @generated
	 * @ordered
	 */
	protected String correlationContainerURI = CORRELATION_CONTAINER_URI_EDEFAULT;

	/**
	 * The default value of the '{@link #getCorrelationContainerProxyURI() <em>Correlation Container Proxy URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationContainerProxyURI()
	 * @generated
	 * @ordered
	 */
	protected static final String CORRELATION_CONTAINER_PROXY_URI_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCorrelationContainerProxyURI() <em>Correlation Container Proxy URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationContainerProxyURI()
	 * @generated
	 * @ordered
	 */
	protected String correlationContainerProxyURI = CORRELATION_CONTAINER_PROXY_URI_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDeltaTime() <em>Delta Time</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeltaTime()
	 * @generated
	 * @ordered
	 */
	protected EList<Double> deltaTime;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CorrelationQueryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ExtensionsPackage.Literals.CORRELATION_QUERY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCorrelationContainerURI() {
		return correlationContainerURI;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCorrelationContainerURI(String newCorrelationContainerURI) {
		String oldCorrelationContainerURI = correlationContainerURI;
		correlationContainerURI = newCorrelationContainerURI;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI, oldCorrelationContainerURI, correlationContainerURI));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCorrelationContainerProxyURI() {
		return correlationContainerProxyURI;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCorrelationContainerProxyURI(String newCorrelationContainerProxyURI) {
		String oldCorrelationContainerProxyURI = correlationContainerProxyURI;
		correlationContainerProxyURI = newCorrelationContainerProxyURI;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_PROXY_URI, oldCorrelationContainerProxyURI, correlationContainerProxyURI));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Double> getDeltaTime() {
		if (deltaTime == null) {
			deltaTime = new EDataTypeUniqueEList<Double>(Double.class, this, ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME);
		}
		return deltaTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI:
				return getCorrelationContainerURI();
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_PROXY_URI:
				return getCorrelationContainerProxyURI();
			case ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME:
				return getDeltaTime();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI:
				setCorrelationContainerURI((String)newValue);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_PROXY_URI:
				setCorrelationContainerProxyURI((String)newValue);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME:
				getDeltaTime().clear();
				getDeltaTime().addAll((Collection<? extends Double>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI:
				setCorrelationContainerURI(CORRELATION_CONTAINER_URI_EDEFAULT);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_PROXY_URI:
				setCorrelationContainerProxyURI(CORRELATION_CONTAINER_PROXY_URI_EDEFAULT);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME:
				getDeltaTime().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI:
				return CORRELATION_CONTAINER_URI_EDEFAULT == null ? correlationContainerURI != null : !CORRELATION_CONTAINER_URI_EDEFAULT.equals(correlationContainerURI);
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_PROXY_URI:
				return CORRELATION_CONTAINER_PROXY_URI_EDEFAULT == null ? correlationContainerProxyURI != null : !CORRELATION_CONTAINER_PROXY_URI_EDEFAULT.equals(correlationContainerProxyURI);
			case ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME:
				return deltaTime != null && !deltaTime.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (correlationContainerURI: ");
		result.append(correlationContainerURI);
		result.append(", correlationContainerProxyURI: ");
		result.append(correlationContainerProxyURI);
		result.append(", deltaTime: ");
		result.append(deltaTime);
		result.append(')');
		return result.toString();
	}

} //CorrelationQueryImpl
