/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: QueryImpl.java,v 1.4 2009/05/05 15:45:22 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.Query;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Query</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getSources <em>Sources</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#isDistinct <em>Distinct</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#isCount <em>Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getOutputElements <em>Output Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getSubQuery <em>Sub Query</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getQuery <em>Query</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getRequiredPaths <em>Required Paths</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getAnnotations <em>Annotations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class QueryImpl extends EObjectImpl implements Query {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSources() <em>Sources</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSources()
	 * @generated
	 * @ordered
	 */
	protected EList<String> sources;

	/**
	 * The default value of the '{@link #isDistinct() <em>Distinct</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDistinct()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DISTINCT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDistinct() <em>Distinct</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDistinct()
	 * @generated
	 * @ordered
	 */
	protected boolean distinct = DISTINCT_EDEFAULT;

	/**
	 * The default value of the '{@link #isCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCount()
	 * @generated
	 * @ordered
	 */
	protected static final boolean COUNT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCount()
	 * @generated
	 * @ordered
	 */
	protected boolean count = COUNT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOutputElements() <em>Output Elements</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutputElements()
	 * @generated
	 * @ordered
	 */
	protected EList<Operand> outputElements;

	/**
	 * The cached value of the '{@link #getSubQuery() <em>Sub Query</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubQuery()
	 * @generated
	 * @ordered
	 */
	protected EList<Query> subQuery;

	/**
	 * The cached value of the '{@link #getRequiredPaths() <em>Required Paths</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequiredPaths()
	 * @generated
	 * @ordered
	 */
	protected EList<EStructuralFeature> requiredPaths;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCAnnotation> annotations;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ExtensionsPackage.Literals.QUERY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.QUERY__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getSources() {
		if (sources == null) {
			sources = new EDataTypeUniqueEList<String>(String.class, this, ExtensionsPackage.QUERY__SOURCES);
		}
		return sources;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDistinct() {
		return distinct;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDistinct(boolean newDistinct) {
		boolean oldDistinct = distinct;
		distinct = newDistinct;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.QUERY__DISTINCT, oldDistinct, distinct));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isCount() {
		return count;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCount(boolean newCount) {
		boolean oldCount = count;
		count = newCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.QUERY__COUNT, oldCount, count));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Operand> getOutputElements() {
		if (outputElements == null) {
			outputElements = new EObjectContainmentWithInverseEList<Operand>(Operand.class, this, ExtensionsPackage.QUERY__OUTPUT_ELEMENTS, ExtensionsPackage.OPERAND__QUERY);
		}
		return outputElements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Query> getSubQuery() {
		if (subQuery == null) {
			subQuery = new EObjectContainmentWithInverseEList<Query>(Query.class, this, ExtensionsPackage.QUERY__SUB_QUERY, ExtensionsPackage.QUERY__QUERY);
		}
		return subQuery;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Query getQuery() {
		if (eContainerFeatureID() != ExtensionsPackage.QUERY__QUERY) return null;
		return (Query)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetQuery(Query newQuery, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newQuery, ExtensionsPackage.QUERY__QUERY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setQuery(Query newQuery) {
		if (newQuery != eInternalContainer() || (eContainerFeatureID() != ExtensionsPackage.QUERY__QUERY && newQuery != null)) {
			if (EcoreUtil.isAncestor(this, newQuery))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newQuery != null)
				msgs = ((InternalEObject)newQuery).eInverseAdd(this, ExtensionsPackage.QUERY__SUB_QUERY, Query.class, msgs);
			msgs = basicSetQuery(newQuery, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.QUERY__QUERY, newQuery, newQuery));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EStructuralFeature> getRequiredPaths() {
		if (requiredPaths == null) {
			requiredPaths = new EObjectResolvingEList<EStructuralFeature>(EStructuralFeature.class, this, ExtensionsPackage.QUERY__REQUIRED_PATHS);
		}
		return requiredPaths;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCAnnotation> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<TRCAnnotation>(TRCAnnotation.class, this, ExtensionsPackage.QUERY__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getOutputElements()).basicAdd(otherEnd, msgs);
			case ExtensionsPackage.QUERY__SUB_QUERY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getSubQuery()).basicAdd(otherEnd, msgs);
			case ExtensionsPackage.QUERY__QUERY:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetQuery((Query)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				return ((InternalEList<?>)getOutputElements()).basicRemove(otherEnd, msgs);
			case ExtensionsPackage.QUERY__SUB_QUERY:
				return ((InternalEList<?>)getSubQuery()).basicRemove(otherEnd, msgs);
			case ExtensionsPackage.QUERY__QUERY:
				return basicSetQuery(null, msgs);
			case ExtensionsPackage.QUERY__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case ExtensionsPackage.QUERY__QUERY:
				return eInternalContainer().eInverseRemove(this, ExtensionsPackage.QUERY__SUB_QUERY, Query.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ExtensionsPackage.QUERY__NAME:
				return getName();
			case ExtensionsPackage.QUERY__SOURCES:
				return getSources();
			case ExtensionsPackage.QUERY__DISTINCT:
				return isDistinct();
			case ExtensionsPackage.QUERY__COUNT:
				return isCount();
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				return getOutputElements();
			case ExtensionsPackage.QUERY__SUB_QUERY:
				return getSubQuery();
			case ExtensionsPackage.QUERY__QUERY:
				return getQuery();
			case ExtensionsPackage.QUERY__REQUIRED_PATHS:
				return getRequiredPaths();
			case ExtensionsPackage.QUERY__ANNOTATIONS:
				return getAnnotations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ExtensionsPackage.QUERY__NAME:
				setName((String)newValue);
				return;
			case ExtensionsPackage.QUERY__SOURCES:
				getSources().clear();
				getSources().addAll((Collection<? extends String>)newValue);
				return;
			case ExtensionsPackage.QUERY__DISTINCT:
				setDistinct((Boolean)newValue);
				return;
			case ExtensionsPackage.QUERY__COUNT:
				setCount((Boolean)newValue);
				return;
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				getOutputElements().addAll((Collection<? extends Operand>)newValue);
				return;
			case ExtensionsPackage.QUERY__SUB_QUERY:
				getSubQuery().clear();
				getSubQuery().addAll((Collection<? extends Query>)newValue);
				return;
			case ExtensionsPackage.QUERY__QUERY:
				setQuery((Query)newValue);
				return;
			case ExtensionsPackage.QUERY__REQUIRED_PATHS:
				getRequiredPaths().clear();
				getRequiredPaths().addAll((Collection<? extends EStructuralFeature>)newValue);
				return;
			case ExtensionsPackage.QUERY__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends TRCAnnotation>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ExtensionsPackage.QUERY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ExtensionsPackage.QUERY__SOURCES:
				getSources().clear();
				return;
			case ExtensionsPackage.QUERY__DISTINCT:
				setDistinct(DISTINCT_EDEFAULT);
				return;
			case ExtensionsPackage.QUERY__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				return;
			case ExtensionsPackage.QUERY__SUB_QUERY:
				getSubQuery().clear();
				return;
			case ExtensionsPackage.QUERY__QUERY:
				setQuery((Query)null);
				return;
			case ExtensionsPackage.QUERY__REQUIRED_PATHS:
				getRequiredPaths().clear();
				return;
			case ExtensionsPackage.QUERY__ANNOTATIONS:
				getAnnotations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ExtensionsPackage.QUERY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ExtensionsPackage.QUERY__SOURCES:
				return sources != null && !sources.isEmpty();
			case ExtensionsPackage.QUERY__DISTINCT:
				return distinct != DISTINCT_EDEFAULT;
			case ExtensionsPackage.QUERY__COUNT:
				return count != COUNT_EDEFAULT;
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				return outputElements != null && !outputElements.isEmpty();
			case ExtensionsPackage.QUERY__SUB_QUERY:
				return subQuery != null && !subQuery.isEmpty();
			case ExtensionsPackage.QUERY__QUERY:
				return getQuery() != null;
			case ExtensionsPackage.QUERY__REQUIRED_PATHS:
				return requiredPaths != null && !requiredPaths.isEmpty();
			case ExtensionsPackage.QUERY__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", sources: ");
		result.append(sources);
		result.append(", distinct: ");
		result.append(distinct);
		result.append(", count: ");
		result.append(count);
		result.append(')');
		return result.toString();
	}

} //QueryImpl
