/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: SimpleSearchQueryImpl.java,v 1.3 2009/05/05 15:45:22 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Simple Search Query</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl#getMaxElements <em>Max Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl#getStartWith <em>Start With</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl#getOrderByExpresions <em>Order By Expresions</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl#getWhereExpression <em>Where Expression</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SimpleSearchQueryImpl extends QueryImpl implements SimpleSearchQuery {
	/**
	 * The default value of the '{@link #getMaxElements() <em>Max Elements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxElements()
	 * @generated
	 * @ordered
	 */
	protected static final int MAX_ELEMENTS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMaxElements() <em>Max Elements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxElements()
	 * @generated
	 * @ordered
	 */
	protected int maxElements = MAX_ELEMENTS_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartWith() <em>Start With</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartWith()
	 * @generated
	 * @ordered
	 */
	protected static final int START_WITH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getStartWith() <em>Start With</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartWith()
	 * @generated
	 * @ordered
	 */
	protected int startWith = START_WITH_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOrderByExpresions() <em>Order By Expresions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOrderByExpresions()
	 * @generated
	 * @ordered
	 */
	protected EList<OrderByElement> orderByExpresions;

	/**
	 * The cached value of the '{@link #getWhereExpression() <em>Where Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWhereExpression()
	 * @generated
	 * @ordered
	 */
	protected WhereExpression whereExpression;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleSearchQueryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ExtensionsPackage.Literals.SIMPLE_SEARCH_QUERY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMaxElements() {
		return maxElements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaxElements(int newMaxElements) {
		int oldMaxElements = maxElements;
		maxElements = newMaxElements;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS, oldMaxElements, maxElements));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getStartWith() {
		return startWith;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartWith(int newStartWith) {
		int oldStartWith = startWith;
		startWith = newStartWith;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_SEARCH_QUERY__START_WITH, oldStartWith, startWith));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<OrderByElement> getOrderByExpresions() {
		if (orderByExpresions == null) {
			orderByExpresions = new EObjectContainmentWithInverseEList<OrderByElement>(OrderByElement.class, this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS, ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY);
		}
		return orderByExpresions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WhereExpression getWhereExpression() {
		return whereExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetWhereExpression(WhereExpression newWhereExpression, NotificationChain msgs) {
		WhereExpression oldWhereExpression = whereExpression;
		whereExpression = newWhereExpression;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION, oldWhereExpression, newWhereExpression);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWhereExpression(WhereExpression newWhereExpression) {
		if (newWhereExpression != whereExpression) {
			NotificationChain msgs = null;
			if (whereExpression != null)
				msgs = ((InternalEObject)whereExpression).eInverseRemove(this, ExtensionsPackage.WHERE_EXPRESSION__SEARCH_QUERY, WhereExpression.class, msgs);
			if (newWhereExpression != null)
				msgs = ((InternalEObject)newWhereExpression).eInverseAdd(this, ExtensionsPackage.WHERE_EXPRESSION__SEARCH_QUERY, WhereExpression.class, msgs);
			msgs = basicSetWhereExpression(newWhereExpression, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION, newWhereExpression, newWhereExpression));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getOrderByExpresions()).basicAdd(otherEnd, msgs);
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION:
				if (whereExpression != null)
					msgs = ((InternalEObject)whereExpression).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION, null, msgs);
				return basicSetWhereExpression((WhereExpression)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				return ((InternalEList<?>)getOrderByExpresions()).basicRemove(otherEnd, msgs);
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION:
				return basicSetWhereExpression(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS:
				return getMaxElements();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__START_WITH:
				return getStartWith();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				return getOrderByExpresions();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION:
				return getWhereExpression();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS:
				setMaxElements((Integer)newValue);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__START_WITH:
				setStartWith((Integer)newValue);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				getOrderByExpresions().clear();
				getOrderByExpresions().addAll((Collection<? extends OrderByElement>)newValue);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION:
				setWhereExpression((WhereExpression)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS:
				setMaxElements(MAX_ELEMENTS_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__START_WITH:
				setStartWith(START_WITH_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				getOrderByExpresions().clear();
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION:
				setWhereExpression((WhereExpression)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS:
				return maxElements != MAX_ELEMENTS_EDEFAULT;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__START_WITH:
				return startWith != START_WITH_EDEFAULT;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				return orderByExpresions != null && !orderByExpresions.isEmpty();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION:
				return whereExpression != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (maxElements: ");
		result.append(maxElements);
		result.append(", startWith: ");
		result.append(startWith);
		result.append(')');
		return result.toString();
	}

} //SimpleSearchQueryImpl
