/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CorrelationEntryImpl.java,v 1.4 2009/05/05 15:45:26 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Correlation Entry</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl#getCorrelationContainer <em>Correlation Container</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl#getTypedKey <em>Key</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl#getTypedValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CorrelationEntryImpl extends EObjectImpl implements BasicEMap.Entry<EObject,EList<EObject>> {
	/**
	 * The cached value of the '{@link #getTypedKey() <em>Key</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypedKey()
	 * @generated
	 * @ordered
	 */
	protected EObject key;

	/**
	 * The cached value of the '{@link #getTypedValue() <em>Value</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypedValue()
	 * @generated
	 * @ordered
	 */
	protected EList<EObject> value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CorrelationEntryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HierarchyPackage.Literals.CORRELATION_ENTRY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationContainer getCorrelationContainer() {
		if (eContainerFeatureID() != HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER) return null;
		return (CorrelationContainer)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationContainer(CorrelationContainer newCorrelationContainer, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newCorrelationContainer, HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCorrelationContainer(CorrelationContainer newCorrelationContainer) {
		if (newCorrelationContainer != eInternalContainer() || (eContainerFeatureID() != HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER && newCorrelationContainer != null)) {
			if (EcoreUtil.isAncestor(this, newCorrelationContainer))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newCorrelationContainer != null)
				msgs = ((InternalEObject)newCorrelationContainer).eInverseAdd(this, HierarchyPackage.CORRELATION_CONTAINER__CORRELATIONS, CorrelationContainer.class, msgs);
			msgs = basicSetCorrelationContainer(newCorrelationContainer, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER, newCorrelationContainer, newCorrelationContainer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject getTypedKey() {
		if (key != null && key.eIsProxy()) {
			InternalEObject oldKey = (InternalEObject)key;
			key = eResolveProxy(oldKey);
			if (key != oldKey) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.CORRELATION_ENTRY__KEY, oldKey, key));
			}
		}
		return key;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject basicGetTypedKey() {
		return key;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTypedKey(EObject newKey) {
		EObject oldKey = key;
		key = newKey;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_ENTRY__KEY, oldKey, key));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EObject> getTypedValue() {
		if (value == null) {
			value = new EObjectResolvingEList<EObject>(EObject.class, this, HierarchyPackage.CORRELATION_ENTRY__VALUE);
		}
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetCorrelationContainer((CorrelationContainer)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER:
				return basicSetCorrelationContainer(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER:
				return eInternalContainer().eInverseRemove(this, HierarchyPackage.CORRELATION_CONTAINER__CORRELATIONS, CorrelationContainer.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER:
				return getCorrelationContainer();
			case HierarchyPackage.CORRELATION_ENTRY__KEY:
				if (resolve) return getTypedKey();
				return basicGetTypedKey();
			case HierarchyPackage.CORRELATION_ENTRY__VALUE:
				return getTypedValue();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER:
				setCorrelationContainer((CorrelationContainer)newValue);
				return;
			case HierarchyPackage.CORRELATION_ENTRY__KEY:
				setTypedKey((EObject)newValue);
				return;
			case HierarchyPackage.CORRELATION_ENTRY__VALUE:
				getTypedValue().clear();
				getTypedValue().addAll((Collection<? extends EObject>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER:
				setCorrelationContainer((CorrelationContainer)null);
				return;
			case HierarchyPackage.CORRELATION_ENTRY__KEY:
				setTypedKey((EObject)null);
				return;
			case HierarchyPackage.CORRELATION_ENTRY__VALUE:
				getTypedValue().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENTRY__CORRELATION_CONTAINER:
				return getCorrelationContainer() != null;
			case HierarchyPackage.CORRELATION_ENTRY__KEY:
				return key != null;
			case HierarchyPackage.CORRELATION_ENTRY__VALUE:
				return value != null && !value.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected int hash = -1;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getHash() {
		if (hash == -1) {
			Object theKey = getKey();
			hash = (theKey == null ? 0 : theKey.hashCode());
		}
		return hash;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHash(int hash) {
		this.hash = hash;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject getKey() {
		return getTypedKey();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setKey(EObject key) {
		setTypedKey(key);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EObject> getValue() {
		return getTypedValue();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EObject> setValue(EList<EObject> value) {
		EList<EObject> oldValue = getValue();
		getTypedValue().clear();
		getTypedValue().addAll(value);
		return oldValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EMap<EObject, EList<EObject>> getEMap() {
		EObject container = eContainer();
		return container == null ? null : (EMap<EObject, EList<EObject>>)container.eGet(eContainmentFeature());
	}

} //CorrelationEntryImpl
