/**********************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HierarchyAdaptersFactory.java,v 1.3 2008/01/24 02:28:17 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/**
 * 
 * @author slavescu
 * @since 4.2
 * 
 */
public class HierarchyAdaptersFactory implements IAdapterFactory {
	protected Class[] adapterList = new Class[] { ResourceMapping.class, IResource.class };

	public static class HierarchyResourceMapping extends ResourceMapping {
		protected final EObject modelObject;

		protected HierarchyResourceMapping(EObject unit) {
			Assert.isNotNull(unit);
			modelObject = unit;
		}

		public Object getModelObject() {
			return modelObject;
		}

		public IProject[] getProjects() {
			IProject project = getPlatformProject(modelObject);
			if (project != null)
				return new IProject[] { project };
			else
				return new IProject[0];
		}

		public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
			IResource resource = getPlatformResource(modelObject);
			if (resource != null)
				return new ResourceTraversal[] { new ResourceTraversal(new IResource[] { resource }, IResource.DEPTH_ONE, 0) };
			else
				return new ResourceTraversal[] { new ResourceTraversal(new IResource[0], IResource.DEPTH_ONE, 0) };
		}

		public String getModelProviderId() {
			return "org.eclipse.tptp.platform.models.hierarchy";
		}

	}

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adaptableObject instanceof EObject) {
			EObject eObject = (EObject) adaptableObject;
			return getAdapter(eObject, adapterType);
		} else if (adaptableObject instanceof AdapterImpl) {
			Notifier notifier = ((AdapterImpl) adaptableObject).getTarget();
			if (notifier instanceof EObject) {
				return getAdapter((EObject) notifier, adapterType);
			}
		}

		return null;
	}

	public static Object getAdapter(EObject eObject, Class adapterType) {
		if (adapterType == ResourceMapping.class) {
			return createHierarchyResourceMapping(eObject);
		} else if (adapterType == IResource.class) {
			return getPlatformResource(eObject);
		} else
			return null;
	}

	public static HierarchyResourceMapping createHierarchyResourceMapping(EObject adaptableObject) {

		return new HierarchyResourceMapping(adaptableObject);
	}

	public static IResource getPlatformResource(EObject eObject) {
		if (eObject != null) {
			return ResourcesPlugin.getWorkspace().getRoot().findMember(EcoreUtil.getURI(eObject).trimFragment().toString().replaceFirst("platform:/resource", ""));
		}
		return null;
	}

	public static IProject getPlatformProject(EObject eObject) {
		if (eObject != null) {
			try {
				return ResourcesPlugin.getWorkspace().getRoot().getProject(EcoreUtil.getURI(eObject).segment(1));
			} catch (IndexOutOfBoundsException e) {
				// ignore EObjects that are not part of a resource
			}
		}
		return null;
	}

	public Class[] getAdapterList() {
		return adapterList;
	}

}
