/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: HierarchySwitch.java,v 1.3 2009/05/05 15:45:27 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.util;

import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent;
import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;
import org.eclipse.hyades.models.hierarchy.AbstractTRCDescription;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.hierarchy.AbstractTRCView;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCExecParameter;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage
 * @generated
 */
public class HierarchySwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static HierarchyPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HierarchySwitch() {
		if (modelPackage == null) {
			modelPackage = HierarchyPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case HierarchyPackage.TRC_PROCESS_PROXY: {
				TRCProcessProxy trcProcessProxy = (TRCProcessProxy)theEObject;
				T result = caseTRCProcessProxy(trcProcessProxy);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_OPTION: {
				TRCOption trcOption = (TRCOption)theEObject;
				T result = caseTRCOption(trcOption);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_AGENT: {
				TRCAgent trcAgent = (TRCAgent)theEObject;
				T result = caseTRCAgent(trcAgent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_AGENT_PROXY: {
				TRCAgentProxy trcAgentProxy = (TRCAgentProxy)theEObject;
				T result = caseTRCAgentProxy(trcAgentProxy);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_CONFIGURATION: {
				TRCConfiguration trcConfiguration = (TRCConfiguration)theEObject;
				T result = caseTRCConfiguration(trcConfiguration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_ENVIRONMENT_VARIABLE: {
				TRCEnvironmentVariable trcEnvironmentVariable = (TRCEnvironmentVariable)theEObject;
				T result = caseTRCEnvironmentVariable(trcEnvironmentVariable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_EXEC_PARAMETER: {
				TRCExecParameter trcExecParameter = (TRCExecParameter)theEObject;
				T result = caseTRCExecParameter(trcExecParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_FILTER: {
				TRCFilter trcFilter = (TRCFilter)theEObject;
				T result = caseTRCFilter(trcFilter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_NODE: {
				TRCNode trcNode = (TRCNode)theEObject;
				T result = caseTRCNode(trcNode);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_MONITOR: {
				TRCMonitor trcMonitor = (TRCMonitor)theEObject;
				T result = caseTRCMonitor(trcMonitor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.ABSTRACT_DEFAULT_EVENT: {
				AbstractDefaultEvent abstractDefaultEvent = (AbstractDefaultEvent)theEObject;
				T result = caseAbstractDefaultEvent(abstractDefaultEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.ABSTRACT_TRC_VIEW: {
				AbstractTRCView abstractTRCView = (AbstractTRCView)theEObject;
				T result = caseAbstractTRCView(abstractTRCView);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.ABSTRACT_TRC_DESCRIPTION: {
				AbstractTRCDescription abstractTRCDescription = (AbstractTRCDescription)theEObject;
				T result = caseAbstractTRCDescription(abstractTRCDescription);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.ABSTRACT_TRC_PROCESS: {
				AbstractTRCProcess abstractTRCProcess = (AbstractTRCProcess)theEObject;
				T result = caseAbstractTRCProcess(abstractTRCProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY: {
				AbstractTRCCollectionBoundary abstractTRCCollectionBoundary = (AbstractTRCCollectionBoundary)theEObject;
				T result = caseAbstractTRCCollectionBoundary(abstractTRCCollectionBoundary);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.UNRESOLVED_CORRELATION: {
				UnresolvedCorrelation unresolvedCorrelation = (UnresolvedCorrelation)theEObject;
				T result = caseUnresolvedCorrelation(unresolvedCorrelation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.CORRELATION_SOURCE_INFO: {
				CorrelationSourceInfo correlationSourceInfo = (CorrelationSourceInfo)theEObject;
				T result = caseCorrelationSourceInfo(correlationSourceInfo);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.CORRELATION_CONTAINER: {
				CorrelationContainer correlationContainer = (CorrelationContainer)theEObject;
				T result = caseCorrelationContainer(correlationContainer);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY: {
				CorrelationContainerProxy correlationContainerProxy = (CorrelationContainerProxy)theEObject;
				T result = caseCorrelationContainerProxy(correlationContainerProxy);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.CORRELATION_ENTRY: {
				@SuppressWarnings("unchecked") Map.Entry<EObject, EList<EObject>> correlationEntry = (Map.Entry<EObject, EList<EObject>>)theEObject;
				T result = caseCorrelationEntry(correlationEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.CORRELATION_ENGINE: {
				CorrelationEngine correlationEngine = (CorrelationEngine)theEObject;
				T result = caseCorrelationEngine(correlationEngine);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HierarchyPackage.TRC_ANNOTATION: {
				TRCAnnotation trcAnnotation = (TRCAnnotation)theEObject;
				T result = caseTRCAnnotation(trcAnnotation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Process Proxy</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Process Proxy</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCProcessProxy(TRCProcessProxy object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Option</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Option</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCOption(TRCOption object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Agent</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Agent</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCAgent(TRCAgent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Agent Proxy</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Agent Proxy</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCAgentProxy(TRCAgentProxy object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Configuration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCConfiguration(TRCConfiguration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Environment Variable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Environment Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCEnvironmentVariable(TRCEnvironmentVariable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Exec Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Exec Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCExecParameter(TRCExecParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Filter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Filter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCFilter(TRCFilter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Node</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Node</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCNode(TRCNode object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Monitor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Monitor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCMonitor(TRCMonitor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract Default Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract Default Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractDefaultEvent(AbstractDefaultEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract TRC View</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract TRC View</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractTRCView(AbstractTRCView object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract TRC Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract TRC Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractTRCDescription(AbstractTRCDescription object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract TRC Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract TRC Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractTRCProcess(AbstractTRCProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract TRC Collection Boundary</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract TRC Collection Boundary</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractTRCCollectionBoundary(AbstractTRCCollectionBoundary object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unresolved Correlation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unresolved Correlation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnresolvedCorrelation(UnresolvedCorrelation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Correlation Source Info</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Correlation Source Info</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCorrelationSourceInfo(CorrelationSourceInfo object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Correlation Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Correlation Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCorrelationContainer(CorrelationContainer object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Correlation Container Proxy</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Correlation Container Proxy</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCorrelationContainerProxy(CorrelationContainerProxy object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Correlation Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Correlation Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCorrelationEntry(Map.Entry<EObject, EList<EObject>> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Correlation Engine</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Correlation Engine</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCorrelationEngine(CorrelationEngine object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Annotation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Annotation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCAnnotation(TRCAnnotation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //HierarchySwitch
