/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExtendedQueryService.java,v 1.2 2007/12/01 00:06:21 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Collection;
import java.util.Properties;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;

/**
 * @author slavescu
 */
public interface IExtendedQueryService {
	int EXECUTE_STATEMENT=1;
	int EXECUTE_QUERY = 2;
	int EXECUTE_UPDATE = 3;
	int EXECUTE_PROCEDURE=4;
	QueryResult executeQuery(Query query,ResourceSet targetResourceSet, Collection notLoadedTypes);
	QueryResult executeQuery(String queryName,ResourceSet targetResourceSet, Collection notLoadedTypes);
	Object executeQuery(String queryString, String targetResourceURI, int mode, Properties p);
	boolean validateQuery(Query query);
	boolean storeQuery(Query query);
}
