/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISessionManager.java,v 1.1 2007/11/27 04:28:30 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * ISessionManager is an interface that provides apis to manage 
 * resource sets based on session ids.  There are cases where resource sets
 * should be created for different session ids.
 */
public interface ISessionManager {
	public static final String CONTEXT_SESSION_ID="_CONTEXT_SESSION_ID_";
	public static final String CONTEXT_SESSION_MANAGER="_CONTEXT_SESSION_MANAGER_";
	/**
	 * Creates a resource based on a unique identifier.
	 * @param sessionID a string that identifies a session
	 * @return a resource set based on a unique identifier
	 */
	public ResourceSet getResourceSet(String sessionID);
}
