/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MonitoredInputStream.java,v 1.2 2007/12/01 00:06:21 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author slavescu
 */
public abstract class MonitoredInputStream extends InputStream {

	InputStream delegateInputStream;

	public MonitoredInputStream(InputStream delegateInputStream) {
		this.delegateInputStream = delegateInputStream;
	}

	public synchronized int available() throws IOException {
		if (isCanceled()) {
			return 0;
		}
		return super.available();
	}

	public synchronized int read(byte[] b, int off, int len) throws IOException {
		if (isCanceled()) {
			return -1;
		}
		len = beforeRead(len);
		int readBytes = delegateInputStream.read(b, off, len);
		return afterRead(readBytes);
	}

	protected int beforeRead(int maxBytesToRead){
		return maxBytesToRead;
	}

	protected int afterRead(int readBytes){
		return readBytes;
	};

	protected boolean isCanceled() {
		return false;
	};

	public int read() throws IOException {
		if (isCanceled()) {
			return -1;
		}
		beforeRead(1);
		int ret = delegateInputStream.read();
		afterRead(1);
		return ret;
	}

	public void close() throws IOException {
		delegateInputStream.close();
	}

	public synchronized void mark(int readlimit) {
		delegateInputStream.mark(readlimit);
	}

	public boolean markSupported() {
		return delegateInputStream.markSupported();
	}

	public int read(byte[] b) throws IOException {
		return read(b, 0, b.length);
	}

	public synchronized void reset() throws IOException {
		delegateInputStream.reset();
	}

	public long skip(long n) throws IOException {
		return delegateInputStream.skip(n);
	}

}