/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExtendedLoader.java,v 1.2 2007/12/01 00:06:25 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.io.InputStream;

import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;


/**
 * @author slavescu
 */
public interface IExtendedLoader extends IXMLLoader{
    //~ Methods ------------------------------------------------------------------------------------

    public abstract void attributeName(int attributeNameId);

    public abstract void attributeValueCharacters(char[] attributeValue);

    public abstract void endElement(int elementNameId, int currentOffset);

    public abstract void error(InvalidEventException exception);

    public abstract void startElement(int elementNameId, boolean hasAttributes, boolean isEmpty);

    public abstract void loadEvents(InputStream inputStream, long offset, long length) throws InvalidXMLException;

}
