/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ImportFilterEngine.java,v 1.3 2010/07/27 02:06:59 jwest Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
/**
 * This Filter engine is primarily used by the XML*Loaders in org.eclipse.hyades.loaders.trace.*
 * in order to determine whether or not a particular element will be filtered our or not. (jgw)  
 *
 * @author Marius Slavescu (slavescu@ca.ibm.com)
 * @since 3.3
 * 
 */
public class ImportFilterEngine extends SimpleSearchQueryEngine {
	protected Map excludeIdsByFeatureIndex = new HashMap();
//	protected Map excludeIdsByFeatureIndex = new HashMap();
	protected HashMap evalResults=new HashMap();
//	protected EvalResult evalResult;
	public ImportFilterEngine(SimpleSearchQuery query, ResourceSet targetResourceSet) {
//		super(convertQuery(query), targetResourceSet);
		super(query,targetResourceSet);
	}
//	private static SimpleSearchQuery convertQuery(SimpleSearchQuery query) {
//		WhereExpression expression = query.getWhereExpression();
//		if (expression instanceof LogicalExpression) {
//			LogicalExpression globalOrLogicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
//			globalOrLogicalExpression.setOperator(LogicalOperators.OR_LITERAL);
//			Set and = new HashSet();
//			Set or = new HashSet();
//			for (Iterator iter = ((LogicalExpression) expression).eAllContents(); iter.hasNext();) {
//				EObject element = (EObject) iter.next();
//				if (element instanceof BinaryExpression) {
//					if (element.eContainer() instanceof LogicalExpression && ((LogicalExpression) element.eContainer()).getOperator() == LogicalOperators.NOT_LITERAL) {
//						and.add(element.eContainer());
//					} else {
//						if (((BinaryExpression) element).getOperator() == RelationalOperators.NEQ_LITERAL) {
//							and.add(element);
//						} else
//							or.add(element);
//					}
//				}
//			}
//			if (!and.isEmpty()) {
//				LogicalExpression andLogicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
//				andLogicalExpression.setOperator(LogicalOperators.AND_LITERAL);
//				andLogicalExpression.getArguments().addAll(and);
//				globalOrLogicalExpression.getArguments().add(andLogicalExpression);
//			}
//			if (!or.isEmpty()) {
//				LogicalExpression orLogicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
//				orLogicalExpression.setOperator(LogicalOperators.OR_LITERAL);
//				orLogicalExpression.getArguments().addAll(or);
//				globalOrLogicalExpression.getArguments().add(orLogicalExpression);
//			}
//			//			for (Iterator iter = and.iterator(); iter.hasNext();) {
//			//				WhereExpression element = (WhereExpression) iter.next();
//			//				globalAndLogicalExpression.getArguments().add(element);
//			//			}
//			query.setWhereExpression(globalOrLogicalExpression);
//		}
//		return query;
//	}
	//	private static SimpleSearchQuery convertQuery1(SimpleSearchQuery query) {
	//		WhereExpression expression = query.getWhereExpression();
	//		if(expression instanceof LogicalExpression)
	//		{
	//			for (Iterator iter = ((LogicalExpression)expression).eAllContents(); iter.hasNext();) {
	//				EObject element = (EObject) iter.next();
	//					if(element instanceof LogicalExpression && ((LogicalExpression)element).getOperator() == LogicalOperators.AND_LITERAL)
	//						((LogicalExpression)element).setOperator(LogicalOperators.OR_LITERAL);
	//			}
	//		}
	//		return query;
	//	}
	public boolean isFiltered(EStructuralFeature sf, Object id, Object value) {
		if (_query == null)
			return false;
		if (value != null) {
			return evaluateAndUpdateIndexes(sf, id, value);
		} else
			return internalIsFiltered(sf, id);
	}
	protected boolean internalIsFiltered(EStructuralFeature sf, Object id) {
		Set ids = (Set) excludeIdsByFeatureIndex.get(sf);
		if (ids!=null && ids.contains(id))
			return true;
		return false;
	}
	protected boolean evaluateAndUpdateIndexes(EStructuralFeature sf, Object id, Object value) {
		if (!evaluate(sf, id, value)) {
			addExcludedId(sf, id);
			return true;
		}
		return false;
	}
	public void addExcludedId(EStructuralFeature sf, Object id) {
		Set ids = (Set) excludeIdsByFeatureIndex.get(sf);
		if (ids == null) {
			ids = new HashSet();
			excludeIdsByFeatureIndex.put(sf, ids);
		}
		ids.add(id);
	}
	protected boolean evaluate(EStructuralFeature sf, Object id, Object value) {
		SSQEEvalResult evalResult = (SSQEEvalResult)evalResults.get(sf);
		if(evalResult==null)
		{
			evalResult = prepareEvalResult(sf);
			evalResults.put(sf,evalResult);
		}
		
		evalResult.evalOnly(sf, value);
		if (evalResult.isComplete()) {
			if (evalResult.booleanValue().booleanValue()) {
				evalResult.resetOnly(sf);
				return true;
			}
		}
		evalResult.resetOnly(sf);
		return false;
	}
	public boolean isFiltered(EStructuralFeature sf, Object id) {
		if (_query == null)
			return false;
		return internalIsFiltered(sf, id);
	}
	public void init() {
		prepareResult();
		populateRootNodesAndClasses();
		buildRequiredTraversalPaths();
		indexWhereExpression();
//		prepareEvalResult();
		evalResults.clear();
	}
	protected SSQEEvalResult prepareEvalResult(EStructuralFeature sf) {
		SimpleSearchQuery tempQuery = _query;
		Set sfs  = new HashSet();
		sfs.add(sf);
		_query = QueryUtils.removeFeatures(_query,sfs,false);
		SSQEEvalResult evalResult = _queryEvaluator.prepareEvalResult();
		//revert to original query
		_query = tempQuery;
		return evalResult;
	}
	//	public void filterOut(EAttribute class_Name, Object lookUpKey) {
	//		
	//	}
}
