/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SessionManagerWrapper.java,v 1.2 2008/01/24 02:28:17 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;

import org.eclipse.hyades.models.hierarchy.util.ISessionManager;

/**
 * This SessionManagerWrapper is a factory class that produces ISessionManager
 * objects.  Exploiters of this factory can register their own ISessionManager instance.
 * 
 * @see org.eclipse.tptp.platform.common.ISessionManager
 */
public final class SessionManagerWrapper {

	/**
	 * reference to an alternate factory
	 */
	protected static ISessionManager _factory = null;
	
	/**
	 * reference to current factory instance
	 */
	protected static ISessionManager _instance = null;
	
	protected static ISessionManager newInstance(){
		return new SessionManagerImpl();
	}
	
	/**
	 * Get the singleton ISessionManager instance
	 */
	public static synchronized ISessionManager instance() {
		if (_instance == null){
			_instance = ((null == _factory) ? newInstance(): _factory);
		}
		return _instance;
	}

	/**
	 * Register an alternative  ISessionManager instance
	 */	
	public static synchronized void setFactory(ISessionManager _factory) {
		_instance = null;
		SessionManagerWrapper._factory = _factory;
	}
}
