/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPTPVirtualMemoryManager.java,v 1.3 2008/01/24 02:28:17 apnan Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.hyades.models.hierarchy.util.ObjectToIntMap;
/**
 * This is incomplete, for testing I use two Maps  
 * 
 * @author slavescu
 * @since 4.2
 */
public class TPTPVirtualMemoryManager {

	Map ownerToData = new IdentityHashMap();
	ObjectToIntMap ownerToIndexBits= new ObjectToIntMapImpl();

	public static final TPTPVirtualMemoryManager INSTANCE = new TPTPVirtualMemoryManager();

	protected TPTPVirtualMemoryManager() {
//		try {
//			org.eclipse.equinox.memory.MemoryManager.addLowMemoryListener(new org.eclipse.equinox.memory.LowMemoryListener(){
//				public int getCount() {
//					// TODO Auto-generated method stub
//					return ownerToData.size();
//				}
//				public String getDescription() {
//					// TODO Auto-generated method stub
//					return "TPTPVirtualMemoryManager";
//				}
//				public long getSize() {
//					int totalSize=0;
//					Set entrySet = ownerToData.entrySet();
//					for (Iterator iter = entrySet.iterator(); iter.hasNext();) {
//						Map.Entry entry = (Map.Entry) iter.next();
//						int size=0;
//						if (entry.getValue() instanceof Object[]) {
//							Object[] v = (Object[]) entry.getValue();
//							for (int j = v.length; --j >= 0;) {
//								if (v[j] instanceof String)
//									size += ((String) v[j]).length()*2;
//								if (v[j] instanceof byte[])
//									size += ((byte[]) v[j]).length;
//								if (v[j] instanceof List)
//									size += ((List) v[j]).size()*4;
//							}
//						}
//						if (size == 0)
//							size = 4;
//						totalSize+=size;
//					}
//					return totalSize;
//				}
//				public void memoryIsLow(int severity) {
////					if(severity ==org.eclipse.equinox.memory.MemoryManager.CRITICAL){
////						Set entrySet = ownerToData.entrySet();
////						for (Iterator iter = entrySet.iterator(); iter.hasNext();) {
////							Map.Entry entry = (Map.Entry) iter.next();
////							entry.setValue(null);
////						}
////						ownerToIndexBits.clear();
////					}
//				}
//			});
//		} catch (Throwable e) {
//		}
	}

	public Object getData(Object owner) {
		return ownerToData.get(owner);
	}

	public void setData(Object owner, Object data) {
		ownerToData.put(owner, data);
	}

	public void dumpStats() {
		ObjectToIntMap objectToCountMap = new ObjectToIntMapImpl();
		ObjectToIntMap objectToSizeMap = new ObjectToIntMapImpl();
		Set entrySet = ownerToData.entrySet();
		for (Iterator iter = entrySet.iterator(); iter.hasNext();) {
			Map.Entry entry = (Map.Entry) iter.next();
			int i = objectToCountMap.getInt(entry.getKey().getClass());
			if (i == ObjectToIntMapImpl.MISSING_VALUE)
				i = 0;
			objectToCountMap.put(entry.getKey().getClass(), i + 1);
			int size = 0;
			if (entry.getValue() instanceof Object[]) {
				Object[] v = (Object[]) entry.getValue();
				for (int j = v.length; --j >= 0;) {
					if (v[j] instanceof String)
						size += ((String) v[j]).length()*2;
					if (v[j] instanceof byte[])
						size += ((byte[]) v[j]).length;
					if (v[j] instanceof List)
						size += ((List) v[j]).size()*4;
				}
			}
			if (size == 0)
				size = 4;
			i = objectToSizeMap.getInt(entry.getKey().getClass());
			if (i == ObjectToIntMapImpl.MISSING_VALUE)
				i = 0;
			objectToSizeMap.put(entry.getKey().getClass(), i+size);
		}

		System.out.println("TPTPVirtualMemoryManager.dumpStats()");
		for (int i = objectToCountMap.getKeys().length; --i >= 0;) {
			if (objectToCountMap.getKeys()[i] != ObjectToIntMapImpl.MISSING_KEY) {
				System.out.println("key=" + ((Class) objectToCountMap.getKeys()[i]).getName() + ", count=" + objectToCountMap.getValues()[i] +", size="+objectToSizeMap.getInt(objectToCountMap.getKeys()[i]));
			}
		}
	}

	public void setIndexBits(Object owner, int offset, int indexBits) {
		//TODO add support for offset
		ownerToIndexBits.put(owner, indexBits);
	}

	public int getIndexBits(Object owner, int offset) {
		//TODO add support for offset
		int i = ownerToIndexBits.getInt(owner);
		if(i==ObjectToIntMapImpl.MISSING_VALUE)
			return 0;
		else
			return i;
	}
}
