/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITraceModelInteraction.java,v 1.2 2010/09/02 17:07:35 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.models.util.provisional;

import org.eclipse.emf.ecore.resource.Resource;

/**
 * Interface for traceModelInteraction Extension Point.
 * 
 * Bug 322951
 */

public interface ITraceModelInteraction {

	/**
	 * Provides actions to complete on a Trace model delete.
	 * @param resource The Trace model.
	 * @param deleteContents <code>true</code> if the contents should be deleted on the file system,
	 * <code>false</code> otherwise.
	 */
	public void traceModelDelete(Resource resource, boolean deleteContents);
	
	/**
	 * Provides actions to complete on a Trace model load.
	 * @param resource The Trace model.
	 */
	public void traceModelLoad(Resource resource);
	
	/**
	 * Provides actions to complete on a Trace model save.
	 * @param resource The Trace model.
	 */
	public void traceModelSave(Resource resource);
	
}
