/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderPlugin.java,v 1.15 2008/04/18 20:15:53 paules Exp $
 * 
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.core.TestCorePreferences;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;


/**
 * This plugin contains the Hyades infrastructure for trace recording.  It contains all the extendible object and interfaces
 * necessary to deploy a recorder on the Agent Controller 
 * @author Ernest Jessee
 */
public class RecorderPlugin extends AbstractUIPlugin
{
	
	/**
	 * the default instance 
	 */
	private static RecorderPlugin plugin;
	
	/**
	 * the plugin's ID as shown in plugin.xml
	 */
	public static final String ID = "org.eclipse.hyades.test.ui"; //$NON-NLS-1$

	private ResourceBundle resourceBundle;
	
	/**
	 * Stores a preference in the plugins preference store with the specified key and value 
	 * @param String key
	 * @param String value
	 */
	public static void storePreference(String key, String value)
	{
		getDefault().getPreferenceStore().setValue(key,value);
	}
	
	/**
     * Resolves the plugin's resource bundle.
     * <p>
     * If the plugin's resource bundle can not be resolved, <code>null</code> is returned.
     * <p>
     * IMPORTANT: Do not use this method to retrieve values from the resource bundle.  This method 
     * is provided so this plugin's resource bundle can be used as the parent of another plugin's 
     * resource bundle.
     * <p>
     * 
     * @return The plugin's resource bundle, otherwise <code>null</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public ResourceBundle getResourceBundle() {
        try {
            if (resourceBundle == null)
                resourceBundle   = Platform.getResourceBundle(Platform.getBundle(ID));
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
        return resourceBundle;
    }
	
	/**
	 * 
	 */
	public RecorderPlugin() {
		super();
		getResourceBundle();
		plugin=this;
		// TODO Auto-generated constructor stub
	}
	/**
	 * acquires a reference to a plugin preference specified by "key"
	 * @param String key
	 * @return String
	 */
	public static String getPreference(String key)
	{
		return getDefault().getPreferenceStore().getString(key);
	}	
	/**
	 * returns the plugins install URL
	 * @return URL
	 */
	public URL getInstallURL()
	{
		return getDescriptor().getInstallURL();
	}
	
	/**
     * Resolves the localized message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * Noteworthy, the resultant message is not formatted (e.g. no message parameter substitution). 
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = UiPlugin.getDefault().getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

	/**
	 * Returns the default instance.
	 */
	public static RecorderPlugin getDefault() 
	{
		return plugin;
	}
	
	
	/**
	 * return the port number specified for the Agent Controller (RAC) as used by Hyades Test.  
	 * The value returned by this method is specified using Window->Preferences->Test
	 * @return String
	 */
	public String getRAServerPort()
	{
		return TestCorePlugin.getDefault().getPluginPreferences().getString(TestCorePreferences.DEFAULT_PORT);
	}
	
	/**
	 * returns the host specified for the Agent Controller as used by Hyades Test
	 * The value returend by this method is specified using Window->Preferences->Test
	 * @return String
	 */
	public String getRAServerHost()
	{
		return UiPlugin.getInstance().getPreferenceStore().getString(TestCorePreferences.DEFAULT_HOST_NAME);
	}
	
	/**
	 * This method causes a dialog box to be displayed warning the user of an exception.
	 * @param Exception e1 - the exception thrown 
	 * @param consequenceDescription - a description of the consequence (i.e. Recording session aborted)
	 * @param cause - a description of the cause. (i.e. Another recorder is active or Agent Controller not available on host/port)
	 * @param dlgTitle - the Title to be displayed on the error dialog
	 */
	public static void reportExceptionToUser(final Exception e1,
										     final String consequenceDescription,
										     final String cause,
										     final String dlgTitle)
	{
		Display.getDefault().asyncExec
		(
			new Runnable()
			{
				public void run()
				{
					Status errorStatus = new Status(IStatus.ERROR,UiPlugin.PLUGIN_ID,IStatus.ERROR,cause,e1);
					new ErrorDialog(Display.getDefault().getActiveShell(),dlgTitle,consequenceDescription,errorStatus,IStatus.ERROR).open();
				
	
				}
	
			}
		);
	}

	/**
     * Resolves the localized message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * Noteworthy, the resultant message is not formatted (e.g. no message parameter substitution). 
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getString(String key)
    {
        return getResourceString(key);
    }

}
