/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CopyAction.java,v 1.1 2008/02/20 18:26:03 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

/**
 * Generic copy action.
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Paul Klicnik
 * @version February 20, 2008
 * @since   February 20, 2008
 */
public class CopyAction extends Action{

	private Clipboard clipboard = null;
	private String[] selectedItems = null;

	public CopyAction( Clipboard clipboardVal ) {

		super();

		clipboard = clipboardVal;
	}

	public void setSelectedStatusItems( String[] selectedItems ) {
		this.selectedItems = selectedItems; 
	}

	public void run() {

		/* Return if there are no selected items */
		if ( this.selectedItems.length == 0 ){
			return;
		}

		/* Copy the items to the clipboard */
		StringBuffer status = new StringBuffer();

		for ( int i = 0; i < selectedItems.length; i++ ){ 
			status.append( selectedItems[i] + "\n" );
		}

		clipboard.setContents( new String[] { status.toString() }, 
				new Transfer[] { TextTransfer.getInstance() });
	}
}
