/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderClientUI.java,v 1.6 2006/05/19 17:16:17 mddunn Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.ui;

import org.eclipse.hyades.execution.recorder.MasterRecorderListener;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.recorder.util.RecorderUtil;
import org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard;

/**
 * @author jnevicos
 *
 * UI Portion of RecorderClient refactor.  Run wizards should call this class.
 */
public class RecorderClientUI extends MasterRecorderListener {

	private Recorder recorder;
	private IRecorderWizard wizard;
	
	public RecorderClientUI(Recorder recorder, IRecorderWizard wizard)
	{
		this.recorder = recorder;
		this.wizard = wizard;
	}
	public static void launchRecorder(final Recorder recorder, IRecorderWizard wizard)
	{

			RecorderUtil.launchRecorder(recorder, wizard);
	}

	public void reportExceptionToUser(Exception e1,
			String consequenceDescription, String cause, String dlgTitle) {

		UiPlugin.reportExceptionToUser(e1, consequenceDescription, cause, dlgTitle);


	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.recorder.MasterRecorderListener#startTestGen()
	 */
	public void startTestGen() {
		if (wizard != null)
			wizard.runTestGen(recorder);
		//remove listener, no longer needed
		RecorderFactory.getInstance().removeListener(recorder, this);
	
	}
}
