/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewGenericRecordingAction.java,v 1.11 2010/05/05 12:32:47 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.ui.actions;

import org.eclipse.hyades.execution.recorder.IRecorderListener;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.tptp.test.internal.recorder.ui.wizards.NewTestFromRecordingWizard;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/**
 * <p>New generic recording action.</p>
 * 
 * @author  Jeff Nevicosi
 * @author  Paul E. Slauenwhite
 * @version May 4, 2010
 * @since   October 28, 2005
 */
public class NewGenericRecordingAction extends Action implements IViewActionDelegate, IRecorderListener {

	private ISelection selection = null;
	
	public NewGenericRecordingAction(){
		
		super();
		
		RecorderFactory.getInstance().addListener(this);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart view) {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		run();		
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	public void run()
	{
		
		NewTestFromRecordingWizard wizard = new NewTestFromRecordingWizard();
		wizard.init(getWorkbench(),getSelection());
		
		//Remove the 'Help' button for consistency (for example, use the circled '?' button):
		wizard.setHelpAvailable(false);

		WizardDialog wizardDialog = new WizardDialog(getWorkbench().getActiveWorkbenchWindow().getShell(),wizard);

		//Ensure the context help is available for this wizard dialog:
		wizardDialog.create();
		
		//Set the size of the wizard dialog (500 x 500) for consistency with the 'File > New' wizard: 
		wizardDialog.getShell().setSize(Math.max(500, wizardDialog.getShell().getSize().x),500);
		
		//Set the context help of the wizard dialog for consistency with the 'File > New' wizard: 
		PlatformUI.getWorkbench().getHelpSystem().setHelp(wizardDialog.getShell(), (PlatformUI.PLUGIN_ID + ".new_wizard_context")); //$NON-NLS-1$
		
		wizardDialog.open();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}
	
	protected IWorkbench getWorkbench()
	{
		return UiPlugin.getDefault().getWorkbench();
	}
	
	protected IStructuredSelection getSelection(){
		
		if(selection instanceof IStructuredSelection){
			return ((IStructuredSelection)(selection));
		}
		else{

			IWorkbenchWindow workbenchWindow = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			
			if (workbenchWindow != null) {
				
				ISelection workbenchWindowSelection = workbenchWindow.getSelectionService().getSelection();
				
				if (workbenchWindowSelection instanceof IStructuredSelection) {
					return ((IStructuredSelection)(workbenchWindowSelection));
				}
			}	
		}
		
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor(){		
		return (TestUIImages.INSTANCE.getImageDescriptor("c", TestUIImages.IMG_GEN_RECORDER_WIZ)); //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#getDisabledImageDescriptor()
	 */
	public ImageDescriptor getDisabledImageDescriptor() {
		return (TestUIImages.INSTANCE.getImageDescriptor("d", TestUIImages.IMG_GEN_RECORDER_WIZ)); //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#getToolTipText()
	 */
	public String getToolTipText(){
		return (UiPluginResourceBundle.NewRecordingWizardPage_TITLE);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.IRecorderListener#updateRecorderActive(boolean)
	 */
	public void updateRecorderActive(boolean active) {
		
		//Disable the action when the recorder is active (e.g. recording):
		setEnabled(!active);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.IRecorderListener#updateStatus(java.lang.String)
	 */
	public void updateStatus(String str) {
		//No-operation.
	}
}