/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StopRecordingAction.java,v 1.12 2009/04/09 18:58:10 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.ui.actions;

import org.eclipse.hyades.execution.recorder.IRecorderListener;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * <p>Stop recording action in the Recorder Control View.</p>
 * 
 * 
 * @author  Ernest Jessee
 * @author  Paul E. Slauenwhite
 * @version April 9, 2009
 * @since   February 1, 2005
 */
public class StopRecordingAction extends Action implements IRecorderListener{
	
	/**
	 * No-argument constructor.
	 */
	public StopRecordingAction(){
		
		super();
		
		RecorderFactory.getInstance().addListener(this);
		
		//Disable the action since a recorder is not running:
		setEnabled(false);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	public void run(){
		
		Recorder recorder = RecorderFactory.getInstance().getActiveRecorder();
		
		if(recorder != null){	
			recorder.stopRecorder();			
		}
		
		//Disable the action so it is only invoked once per recording:
		setEnabled(false);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor(){
		return (TestUIImages.INSTANCE.getImageDescriptor("c", TestUIImages.IMG_STOP_RECORDING));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#getDisabledImageDescriptor()
	 */
	public ImageDescriptor getDisabledImageDescriptor() {
		return (TestUIImages.INSTANCE.getImageDescriptor("d", TestUIImages.IMG_STOP_RECORDING));
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#getToolTipText()
	 */
	public String getToolTipText(){
		return (UiPluginResourceBundle.StopRecordingAction_STOP_RECORDING_BUTTON_TOOLTIP); 
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.IRecorderListener#updateRecorderActive(boolean)
	 */
	public void updateRecorderActive(boolean active){
		//No-operation.
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.IRecorderListener#updateStatus(java.lang.String)
	 */
	public void updateStatus(String status) {
		
		//Enable the action only when a recorder is running:
		setEnabled(TestCorePluginResourceBundle.RecorderClient_STATUS_RECORDING.equals(status.trim()));		
	}
}
