/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderWizard.java,v 1.12 2008/04/10 14:53:36 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.ui.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.recorder.IRecorderListenerFullFeedback;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.internal.testgen.ui.TestgenUIWrapper;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/**
 * Abstract Wizard which should be extended by wizards associated with Recorders.  This object automatically handles the recorders 
 * control view and hanles save calls to each individual wizard page is owns.
 * <p/>
 * 
 * 
 * @author  Ernest Jessee
 * @author  Paul E. Slauenwhite
 * @version April 10, 2008
 * @since   February 1, 2005
 * @deprecated Use the Generic Recorder Framework (IGenericRecorderWizard and IGenericRecorderPage).
 */
public abstract class RecorderWizard
	extends HyadesNewWizard
	implements INewWizard, IRunnableWithProgress, IRecorderWizard
{

	protected IProgressMonitor monitor = null;
	/**
	 * this method, when implemented should start the target recorder
	 */
	public void run(IProgressMonitor monitor)throws InvocationTargetException, InterruptedException
	{
		this.monitor = monitor;
		run();
	}
	
	public abstract void run();
	
	/**
	 * method which passes through the wizardpage collection and calls save on each
	 */
	public void saveSettings()
	{
		
		IWizardPage[] wizPages = getPages();
		
		for(int i=0; i<wizPages.length;i++)
		{
			
			ITestGenWizardPage wizPage = (ITestGenWizardPage)wizPages[i];
			wizPage.saveSettings();
		}
		
	}


	/**
	 * handles the finish button by resetting the control view and initiating a run call on the extender class
	 */
	public boolean performFinish()
	{		

		saveSettings();
		if (!verifyRecorderData())
			return false;
		RecorderControlView.getInstance().reset();
		
		
		IRunnableWithProgress op = new WorkspaceModifyDelegatingOperation(this);
		try 
		{
			getContainer().run(false, true, op);
			return true;
		}
		catch (InvocationTargetException e) 
		{
			e.printStackTrace();
			return false;
		} catch (InterruptedException e) {
			e.printStackTrace();
			return false;
		}
	}
	

	

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile arg0) throws Exception
	{
		return true;
	}
	/**
	 * extenders may use this to ensure all data collected is OK, popup a verifaction dialog.
	 * If false is returned, performFinish will return false & run() is not executed.
	 * By default this method simply returns true.     
	 * @return
	 */
	protected boolean verifyRecorderData()
	{
		return true;
	}

	/**
	 * Method used by extending classes to add additional IRecorderListeners
	 *
	 */
	public void registerListeners()
	{		
	}
	
	public void runTestGen(Recorder recorder)
	{
		String scriptGenID = recorder.getScriptgenID();
		if (scriptGenID == null || scriptGenID.equals("-1"))
			return;
		String scriptGenName = TestGeneratorFactory.getInstance().getGeneratorName(scriptGenID);
		String recordingPath = recorder.getRecordingPath();
		RecorderFactory.getInstance().controlMessage(recorder, IRecorderListenerFullFeedback.VIEW_MESSAGE,
				TestCorePluginResourceBundle.RecorderClient_Test_generation_started_with_generator___4 + " " + scriptGenName); 
			
		IFile traceFile;
		
		if(recordingPath.endsWith(".rec")) //$NON-NLS-1$
		{
			traceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(recordingPath+"model")); //$NON-NLS-1$
		}
		else
		{
			traceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(recordingPath));
		}
							
		if(traceFile.exists())
		{
			RecorderFactory.getInstance().controlMessage(recorder, IRecorderListenerFullFeedback.VIEW_MESSAGE,
				TestCorePluginResourceBundle.RecorderClient_TEST_TO_BE_GENERATED + " " + recorder.getTestPath()); 
			TestgenUIWrapper wrapper = new TestgenUIWrapper(scriptGenID, traceFile, recorder.getTestPath());
			wrapper.addListener(RecorderControlView.getInstance());
			wrapper.launchGenerator();
			//testgen success notify message is handled from the recorderControlView
		}
		else
		{
			RecorderFactory.getInstance().controlMessage(recorder, IRecorderListenerFullFeedback.VIEW_MESSAGE,
					TestCorePluginResourceBundle.RecorderClient_UNABLE_TO_GENERATE_NO_TRACE_FILE); 
		}
	}


}
