/**********************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GenerateTestCommandHandler.java,v 1.2 2010/05/20 17:45:31 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.RunTestGenWizard;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * <p>Handler for the generate test from a recording command (see
 * the <code>org.eclipse.ui.handlers</code> and 
 * <code>org.eclipse.ui.commands</code> extension points in this plug-in's
 * <code>plugin.xml</code> file).</p>
 *  
 * <p>The generate test from a recording command is used by the 
 * 'Generate Test' context menu (see <code>org.eclipse.ui.menus</code> extension point) 
 * and 'Alt+Shift+T, T' key binding (see <code>org.eclipse.ui.bindings</code> extension 
 * point).</p>
 * 
 * <p>Note: This handler only supports single recording file (*.recmodel) selections 
 * in a navigator (e.g. Package Explorer), as declared in the implementation of the 
 * <code>org.eclipse.ui.handlers</code> extension point.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version May 20, 2010
 * @since   April 23, 2009
 * @deprecated As of TPTP 4.7.0, the 'Generate Test' menu and 'Alt+Shift+T, G' command/shortcut is replaced by the 'TPTP Test From Recording' wizard. 
 */
public class GenerateTestCommandHandler extends AbstractHandler{
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.AbstractHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {

		ISelection selection = HandlerUtil.getCurrentSelection(event); 

		if(selection != null){

			IStructuredSelection structuredSelection = null;
			
			if(selection instanceof IStructuredSelection){
				structuredSelection = ((IStructuredSelection)(selection));		
			}
			else{
				structuredSelection = new StructuredSelection(selection);
			}
			
			RunTestGenWizard wizard = new RunTestGenWizard((IFile)(structuredSelection.getFirstElement()));
			wizard.init(PlatformUI.getWorkbench(), structuredSelection);

			WizardDialog wizardDialog = new WizardDialog(HandlerUtil.getActiveShell(event), wizard);
			wizardDialog.open();	
			
			wizard.dispose();
		}		

		return null;
	}
}
