/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FileLocationSelectionWizardpage.java,v 1.35 2010/05/28 20:30:36 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

/**
 * <p>Extension of the {@link TestLocationPage} wizard location page for specifying test files.</p>
 * 
 * <p>In addition:</p>
 * 
 * <ul>
 * <li>Configured to save and restore the last selected file.</li>
 * <li>Configured to allow overwriting existing resources.</li>
 * </ul>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Ernest Jessee
 * @author  Jerome Bozier
 * @version May 28, 2010
 * @since   February 1, 2005
 * @see     TestLocationPage
 */
public abstract class FileLocationSelectionWizardpage extends TestLocationPage implements ITestGenWizardPage {

	/**
	 * @deprecated As of TPTP V4.7.0, this variable is considered internal.
	 * @noreference This method is not intended to be referenced by clients.
	 */
	//Required for backward compatibility.
	protected Listener modifyListener = this;

	/**
	 * @deprecated As of TPTP V4.7.0, this variable is considered internal.
	 * @noreference This method is not intended to be referenced by clients.
	 */
	//Required for backward compatibility.
	protected TreeViewer tree = null;

	private boolean saveSelection = false;
	
	private IWorkspaceRoot workspaceRoot = null;

	public FileLocationSelectionWizardpage(){
		this(true);
	}

	public FileLocationSelectionWizardpage(boolean saveSelection){
		this(saveSelection, null);
	}

	public FileLocationSelectionWizardpage(boolean saveSelection, IStructuredSelection selection){

		super("fileLocation", selection); //$NON-NLS-1$

		this.saveSelection = saveSelection;
		this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
		
		setAllowOverwrite(true);
	}

	public abstract String getFileExtension();

	/**
	 * @deprecated As of TPTP V4.7.0, this method is no longer used.
	 * @noreference This method is not intended to be referenced by clients.
	 */
	//Required for backward compatibility.
	public String getFileNameLabel() {
		return ""; //$NON-NLS-1$
	}
	
	public abstract String getTitle();

	public abstract String getDescription();

	/**
	 * @deprecated As of TPTP V4.7.0, use {@link #getFilePath()}.
	 * @noreference This method is not intended to be referenced by clients.
	 */
	//Required for backward compatibility.
	protected IContainer getSelectedContainer(){

		String filePath = getFilePath();

		if(filePath != null){

			IFile file = workspaceRoot.getFile(new Path(filePath));

			if(file != null){
				return (file.getParent());
			}
		}

		return null;
	}

	/**
	 * @deprecated As of TPTP V4.7.0, use {@link #getFilePath()}.
	 * @noreference This method is not intended to be referenced by clients.
	 */
	//Required for backward compatibility.
	public String getSelectedFilePath(){
		return (getFilePath());
	}

	/**
	 * @deprecated As of TPTP V4.7.0, use {@link #setContainerFullPath(IPath)}.
	 * @noreference This method is not intended to be referenced by clients.
	 */
	//Required for backward compatibility.
	protected void setSelectedFilePath(String selectedFilePath){

		if((selectedFilePath != null) && (selectedFilePath.trim().length() > 0)){

			setContainerFullPath(new Path(selectedFilePath));

			saveSettings();
		}
	}

	/**
	 * @deprecated As of TPTP V4.7.0, use {@link #getFileName()}.
	 * @noreference This method is not intended to be referenced by clients.
	 */
	//Required for backward compatibility.
	public String getSelectedFileName(){
		return (getFileName());
	}

	/**
	 * @deprecated As of TPTP V4.7.0, this method is no longer used.
	 * @noreference This method is not intended to be referenced by clients.
	 */
	//Required for backward compatibility.
	protected void autoSelectProject(){
		//No-operation.
	}

	protected Image getObjectImage(Object element){
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage#saveSettings()
	 */
	public void saveSettings(){

		if(saveSelection){

			String filePathString = getFilePath();

			if((filePathString != null) && (filePathString.length() > 0)){
				UiPlugin.getDefault().getPreferenceStore().setValue(getPreferenceKey(), filePathString);
			}
		}			
	}
	
	/**
	 * Provided for implementing classes which use the same class in multiple situations.  Can qualify the
	 * preference key depending on other settings.  Thus, different default settings can be saved to / loaded
	 * from metadata.
	 * @return
	 */
	protected String getPreferenceKey()
	{
		return getClass().getName();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.common.ui.wizard.LocationPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent){
		
		setTitle(getTitle());
		setDescription(getDescription()); 
		
		String fileExtension = getFileExtension();
		
		setFileExtension(fileExtension);

		Image objectImage = getObjectImage(workspaceRoot.getFile(new Path("/sampleProject/sampleFile." + fileExtension))); //$NON-NLS-1$

		//If extenders specify an object image, assume the location page is used for file selection:
		if(objectImage != null){		
			
			setFileImage(objectImage);
			setDisplayFiles(true);
		}
		
		if(saveSelection){

			String filePathString = UiPlugin.getDefault().getPreferenceStore().getString(getPreferenceKey());

			if((filePathString != null) && (filePathString.length() > 0)){

				IPath filePath = new Path(filePathString).removeFileExtension();

				setContainerFullPath(filePath.removeLastSegments(1));
				setFileName(filePath.lastSegment());
			}
		}
		
		super.createControl(parent);

		//Required for backward compatibility.
		autoSelectProject();

		//Required for backward compatibility.
		tree = internal_getTreeViewer();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.DialogPage#setControl(org.eclipse.swt.widgets.Control)
	 */
	protected void setControl(Control control) {
		
		super.setControl(control);

		if(control != null){
			PlatformUI.getWorkbench().getHelpSystem().setHelp(control, getContextHelpID());
		}
	}
}
