/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RunTestGenWizard.java,v 1.19 2010/05/20 17:45:30 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.internal.execution.recorder.utilities.RecorderFileUtil;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.internal.testgen.ui.TestgenUIWrapper;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

/**
 * <p>Extension of the {@link HyadesNewWizard} wizard for generating test suites using a test generator.</p>
 * 
 * 
 * @author  Ernest Jessee
 * @author  Paul E. Slauenwhite
 * @version May 20, 2010
 * @since   February 1, 2005
 * @deprecated As of TPTP 4.7.0, the 'Generate Test' menu and 'Alt+Shift+T, G' command/shortcut is replaced by the 'TPTP Test From Recording' wizard. 
 */
public class RunTestGenWizard extends HyadesNewWizard implements INewWizard, IRunnableWithProgress {
	
	private TestSuiteLocationSelectionPage testFileSelectionPage;

	private TestGeneratorSelectorPage generatorSelectorPage;

	private IFile selectedRecModelFile;
	
	public RunTestGenWizard(IFile recModelFile)
	{
		super();
		
		this.selectedRecModelFile = recModelFile;
        
		setWindowTitle(UiPluginResourceBundle.NewRecordingWizardPage_TITLE); 
	}

	public void run(IProgressMonitor monitor)
		throws InvocationTargetException, InterruptedException
	{
		//No-operation.		
	}
	
	protected boolean createObject(IFile file) throws Exception
	{
		return false;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		saveSettings();
		String generatorID = generatorSelectorPage.getSelectedGeneratorID();
				
		IConfigurationElement generatorElement = TestGeneratorFactory.getInstance().getGeneratorConfigElement(generatorID);
		if(generatorElement == null)	
		{
			UiPlugin.logError(UiPluginResourceBundle.RunTestGenWizard_UNABLE_TO_LOAD_SELECTED_GENERATOR_ERROR_MSG); 
			return false;
		}
		String tsName = testFileSelectionPage.getFilePath();
		IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(tsName));
		if(RecorderFileUtil.fileExists(file))
		{
			boolean b = MessageDialog.openConfirm(getWorkbench().getActiveWorkbenchWindow().getShell(), 
					UiPluginResourceBundle.RunTestGenWizard_TESTSUITE_EXISTS_TITLE,
					UiPluginResourceBundle.RunTestGenWizard_TESTSUITE_EXISTS
					);
			if (!b)
				return b;
			RecorderFileUtil.deleteFile(file);
		}
		
		TestgenUIWrapper wrapper = new TestgenUIWrapper(generatorID, selectedRecModelFile, testFileSelectionPage.getFilePath());
		wrapper.launchGenerator();
		return true;
		
	}
	
	private void saveSettings()
	{
		IWizardPage pages[] = getPages();
		for(int i=0; i<pages.length; i++)
		{
			((ITestGenWizardPage)pages[i]).saveSettings();
		}
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages(){
		
		generatorSelectorPage = new TestGeneratorSelectorPage();
		
		addPage(generatorSelectorPage);

		testFileSelectionPage = new TestSuiteLocationSelectionPage(selectedRecModelFile);
		
		addPage(testFileSelectionPage);		
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#dispose()
	 */
	public void dispose()
	{
		//No-operation.		
	}
}
