/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestGeneratorSelectorPage.java,v 1.13 2010/05/20 17:45:30 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility;
import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility.TestGenUIException;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/**
 * <p>Wizard page which prompts the user for the test generator to use in generating a test.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Ernest Jessee
 * @version May 20, 2010
 * @since   February 1, 2005
 * @deprecated As of TPTP 4.7.0, the 'Generate Test' menu and 'Alt+Shift+T, G' command/shortcut is replaced by the 'TPTP Test From Recording' wizard. 
 */
public class TestGeneratorSelectorPage extends WizardPage implements ITestGenWizardPage
{
	
	private Combo generatorsCombo;

	public TestGeneratorSelectorPage()
	{
		super(TestGeneratorSelectorPage.class.getName());
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage#getContextHelpID()
	 */
	public String getContextHelpID(){
		return (UiPlugin.getID() + ContextIds.NEW_TEST_FROM_RECORDING_WIZARD);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.testgen.ui.wizards.ITestGenWizardPage#saveSettings()
	 */
	public void saveSettings()
	{
			//DO NOT SAVE SETTINGS, ALWAYS USE THE FIRST GENERATOR
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite grandParent)
	{
		setTitle(UiPluginResourceBundle.NewRecordingWizardPage_TITLE); 
		setDescription(UiPluginResourceBundle.TEST_GENERATION_SELECT_GENERATOR_WIZARDPAGE_DESCRIPTION); 
		Composite parent = new Composite(grandParent,SWT.NULL);
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(parent,getContextHelpID());
		TestgenUIUtility.assignGridLayout(parent,2);
		Label label = TestgenUIUtility.createLabel(parent,UiPluginResourceBundle.TEST_GENERATOR_SELECTION_LABEL,null); 
		generatorsCombo = new Combo(parent,SWT.READ_ONLY|SWT.DROP_DOWN);
		
		String generatorIDs[] = TestGeneratorFactory.getInstance().getGeneratorIDs();
		
		if(generatorIDs.length > 0){
			
			for(int counter = 0; counter < generatorIDs.length; counter++){
				generatorsCombo.add(TestGeneratorFactory.getInstance().getGeneratorName(generatorIDs[counter]));
			}
				
			generatorsCombo.select(0);
		}
		else{
			setPageComplete(false);
		}
		
		try
		{
			TestgenUIUtility.layoutControlInGrid(label,1,GridData.HORIZONTAL_ALIGN_BEGINNING);
			TestgenUIUtility.layoutControlInGrid(generatorsCombo,1,GridData.GRAB_HORIZONTAL|GridData.HORIZONTAL_ALIGN_FILL);
			
		}
		catch (TestGenUIException e)
		{
			UiPlugin.logError(e);
		}
		
		setControl(parent);
	}

	public String getSelectedGeneratorID()
	{
		return TestGeneratorFactory.getInstance().getGeneratorIDByIndex(generatorsCombo.getSelectionIndex());		
	}
}
