/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteLocationSelectionPage.java,v 1.17 2010/05/20 17:45:30 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.jdt.core.JavaCore;

/**
 * <p>Extension of the {@link FileLocationSelectionWizardpage} wizard for generating test suites using a test generator.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Ernest Jessee
 * @version May 20, 2010
 * @since   February 1, 2005
 * @deprecated As of TPTP 4.7.0, the 'Generate Test' menu and 'Alt+Shift+T, G' command/shortcut is replaced by the 'TPTP Test From Recording' wizard. 
 */
public class TestSuiteLocationSelectionPage extends FileLocationSelectionWizardpage{
	
	public TestSuiteLocationSelectionPage(IFile recordingModelFile){
		
		super(true);
		
		if(recordingModelFile != null){		
			UiPlugin.getDefault().getPreferenceStore().setValue(getPreferenceKey(), (recordingModelFile.getFullPath().removeFileExtension().toString() + "." + getFileExtension())); //$NON-NLS-1$
		}		
	}
	
	public String getDescription()
	{
		return UiPluginResourceBundle.TestsuiteLocationWizardPage_DESCRIPTION; 
	}

	public String getFileExtension()
	{
		return "testsuite"; //$NON-NLS-1$
	}

	public String getPreferenceID()
	{
		return null;
	}

	public String getTitle()
	{
		return UiPluginResourceBundle.NewRecordingWizardPage_TITLE; 
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage#getContextHelpID()
	 */
	public String getContextHelpID(){
		return (UiPlugin.getID() + ContextIds.NEW_TEST_FROM_RECORDING_WIZARD);
	}

	/**
	 * <p>Determines if the page's controls contain valid values.</p>
	 * 
	 * <p>Valid values require all of the following conditions (in order):</p>
	 * 
	 * <ol>
	 * <li>{@link TestLocationPage#validatePage(boolean)}</li>
	 * <li>The project is Java-capable.</li>
	 * </ol>
	 * 
	 * <p>If the values are not valid, an error message is displayed if the page's message is to be 
	 * updated and the method returns false.</p>
	 * 
	 * @param updateMessage <code>true</code> if the page's message is to be updated, otherwise <code>false</code>.
	 * @return <code>true</code> if the page's controls contain valid values, otherwise <code>false</code>.
	 * @see TestLocationPage#validatePage(boolean)
	 */
	protected boolean validatePage(boolean updateMessage){
	
		//Case 1: Container and/or file name are missing or invalid:
		if(!super.validatePage(updateMessage)){
			return false;
		}
		
		//Case 2: Project type is incorrect:
		try {					

			if(!ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(getFilePath())).getProject().hasNature(JavaCore.NATURE_ID)){					

				if(updateMessage){

					setMessage(null);
					setErrorMessage(UiPluginResourceBundle.TestLocationPage_INCORRECT_CONTAINER_TYPE);
				}

				return false;
			}
		} 
		catch (Exception e) {

			//Rare Condition: Project does not exist or is not opened.
			if(updateMessage){

				setMessage(null);
				setErrorMessage(UiPluginResourceBundle.TestLocationPage_INCORRECT_CONTAINER_TYPE);
			}

			return false;
		}		
		
		//Case 3 (default): Container and file exist:
		if(updateMessage){

			setMessage(null);
			setErrorMessage(null);
		}
		
		return true;
	}
}
