/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestgenUIWrapper.java,v 1.7 2007/05/02 19:35:51 paules Exp $
 *  
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.internal.testgen.ui;

import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.core.testgen.ITestgenListener;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.ui.testgen.util.TestgenUtil;

/**
 * @author jnevicos
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TestgenUIWrapper {

	String generatorID = null;
	String generatorName = null;
	IFile recFile = null;
	String outFileName = null;
	boolean bSuccess = false;
	ArrayList listeners;
	
	public TestgenUIWrapper(String generatorID, IFile selectedRecModelFile, String outputFileName)
	{
		this.generatorID = generatorID;
		generatorName = TestGeneratorFactory.getInstance().getGeneratorName(generatorID);
		this.recFile = selectedRecModelFile;
		this.outFileName = outputFileName;
	}
	
	public TestgenUIWrapper(String generatorID, String recFilePath, String outputFileName)
	{
		recFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(recFilePath));
		this.generatorID = generatorID;
		generatorName = TestGeneratorFactory.getInstance().getGeneratorName(generatorID);
		this.outFileName = outputFileName;
		
	}
	
	public synchronized void addListener(ITestgenListener listener)
	{
		
		if (listeners == null)
			listeners = new ArrayList();
		listeners.add(listener);
	}
	
	public synchronized void removeListener(ITestgenListener listener)
	{
		if (listeners == null)
			return;
		if (listeners.contains(listener))
		{
			listeners.remove(listener);
		}
	}
		
	public void launchGenerator() {
		ITestgenListener[] aListeners = null;
		if (listeners != null)
		{
			aListeners = new ITestgenListener[listeners.size()];
			for (int i = 0; i < listeners.size(); i++)
			{
				aListeners[i] = (ITestgenListener) listeners.get(i);
			}
		}
		TestgenUtil.launchGenerator(recFile, outFileName, generatorID, aListeners, generatorName);
	}
}

