/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestUI.java,v 1.18 2010/02/03 13:57:16 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui;

import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

/**
 * <p>Utility methods for test UIs.</p>
 *
 * 
 * @author      Paul E. Slauenwhite
 * @author      Marcel Paternostro
 * @version     February 3, 2010
 * @since       February 1, 2005
 */
public class TestUI implements ICommonConstants {		
	
	/**
	 * File extension for the report resources
	 */
	public final static String REPORT_FILE_EXTENSION = "report"; //$NON-NLS-1$

	/**
	 * Open editor preference store for report resources.
	 * <p/>
	 * 
	 * @deprecated As of TPTP 4.5.0, use {@link #OPEN_EDITOR}.
	 */
	public final static String REPORT_OPEN_EDITOR = "OpenReportEditor"; //$NON-NLS-1$
	
	/**
	 * Preference store key for opening the editor.
	 * <p/>
	 * Possible values include:
	 * <ul>
	 * <li><code>MessageDialogWithToggle.PROMPT</code></li>
	 * <li><code>MessageDialogWithToggle.ALWAYS</code></li>
	 * <li><code>MessageDialogWithToggle.NEVER</code></li>
	 * </ul> 
	 */
	public final static String OPEN_EDITOR = "openEditor"; //$NON-NLS-1$

	public final static String EXECUTION_FILTER = "execFilter";	//$NON-NLS-1$

	/**
	 * <p>Common Separated Value (CSV) lower-case file extension.</p>
	 * 
	 * <p><b>Note:</b> This file extension MUST be in lower-case.</p>
	 */
	public final static String CSV_FILE_EXTENSION = "csv"; //$NON-NLS-1$

    /**
     * Flag used to display or not warnings encountered during launch validation.
     * see Bugzilla #107652
     */
    public static final String HIDE_LAUNCH_VALIDATION_WARNING = "HideLaunchValidationWarning"; //$NON-NLS-1$

	/**
	 * Test UI report manager. 
	 */
	private static ReportManager reportManager;

	/**
	 * Disposes the resources used by this class.
	 */
	static void dispose()
	{
		if(reportManager != null)
		{
			reportManager.saveIntoPreferenceStore();
			reportManager.dispose();
			reportManager = null;
		}		
	}
	
	/**
	 * Returns <code>true</code> if the file extension is supported or 
	 * <code>false</code> otherwise.
	 * 
	 * @param fileExtension
	 * @return boolean
	 */
	public static boolean isSupportedFileExtension(String fileExtension)
	{
		if(TEST_SUITE_FILE_EXTENSION.equals(fileExtension))
			return true;

		if(DEPLOYMENT_FILE_EXTENSION.equals(fileExtension))
			return true;
			
		if(LOCATION_FILE_EXTENSION.equals(fileExtension))
			return true;
		
		if(ARTIFACT_FILE_EXTENSION.equals(fileExtension))
			return true;
		
		if(EXECUTION_FILE_EXTENSION.equals(fileExtension))
		    return true;
		
		if(DATAPOOL_FILE_EXTENSION.equals(fileExtension))
			return true;

		return false;
	}
	
	/**
	 * Returns the supported file extension as a sorted string
	 * array.
	 * @return String[]
	 */	
	public static String[] getSupportedFileExtensions()
	{	
		return new String[]{DEPLOYMENT_FILE_EXTENSION, LOCATION_FILE_EXTENSION, ARTIFACT_FILE_EXTENSION, TEST_SUITE_FILE_EXTENSION, EXECUTION_FILE_EXTENSION, DATAPOOL_FILE_EXTENSION};
	}
	
	/**
	 * Returns the report manager for the Test UI plugin. 
	 * @return ReportManager
	 */
	public static ReportManager getReportManager()
	{
		if(reportManager == null)
		{
			reportManager = new ReportManager(UiPlugin.getInstance(), CommonUIPlugin.EP_REPORT_EXTENSIONS);
			reportManager.loadFromPluginRegistry();
			reportManager.loadFromPreferenceStore();
		}
		
		return reportManager;
	}
}
