/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestUIConstants.java,v 1.12 2010/05/05 12:32:50 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui;

import org.eclipse.swt.graphics.RGB;

/**
 * <p>Test UI constants.</p>
 * 
 * 
 * @author  Jerome Gout
 * @author  Paul E. Slauenwhite
 * @version May 4, 2010
 * @since   February 1, 2005
 */
public interface TestUIConstants {
	
	/**
	 * Test Perspective identifier as defined in the implementation of the <code>org.eclipse.ui.perspectives</code> extension point in this plug-in.
	 */
	public static final String TEST_PERSPECTIVE_ID = "org.eclipse.hyades.ui.perspective.TestPerspective";
	
	/**
	 * <p>Category identifier as defined in the <code>org.eclipse.ui.newWizards</code> 
	 * extension point for new wizards to create test containers and assets.</p>
	 */
	public static final String NEW_TEST_WIZARD_CATEGORY = "org.eclipse.hyades.test.ui.wizards.new";
	
    /**
     * @deprecated use TAG_FRAGMENT instead. We no longer should persist the full URI because it contains file path
     */
	public static final String TAG_FACTORY_ID = "factoryID"; //$NON-NLS-1$
	public static final String TAG_NODE_KIND = "nodeKind"; //$NON-NLS-1$
    /**
     * @deprecated use TAG_FRAGMENT instead. We no longer should persist the full URI because it contains file path
     */
	public static final String TAG_NAME = "name"; //$NON-NLS-1$
	public static final String TAG_TYPE = "type"; //$NON-NLS-1$
    /**
     * @deprecated use TAG_FRAGMENT instead. We no longer should persist the full URI because it contains file path
     */
    public static final String TAG_URI = "uri"; //$NON-NLS-1$
    /**
     * @deprecated This constant was mistakenly published.
     */
	public static final String TAG_URI_FRAGMENT = "uriFragment"; //$NON-NLS-1$
    public static final String TAG_URI_ROOT = "uriRoot"; //$NON-NLS-1$
    /**
     * @deprecated This constant was mistakenly published.
     */
	public static final String TAG_IDENTIFIER = "identifier"; //$NON-NLS-1$
    /**
     * @deprecated This constant was mistakenly published.
     */
	public static final String TAG_UNDERLYING_RESOURCE = "underlyingResource"; //$NON-NLS-1$
    /**
     * @deprecated This constant was mistakenly published.
     */
	public static final String TAG_VERDICT = "verdict"; //$NON-NLS-1$
	
	//- hyades default value of tag TAG_NODE_KIND 
	public static final String ARTIFACT_NODE = "artifactNode"; //$NON-NLS-1$
	public static final String ARTIFACT_FILE_NODE = "artifactFileNode"; //$NON-NLS-1$
	public static final String DATAPOOL_NODE = "datapoolNode"; //$NON-NLS-1$
	public static final String DATAPOOL_FILE_NODE = "datapoolFileNode"; //$NON-NLS-1$
	public static final String EXECUTION_FILE_NODE = "executionFileNode"; //$NON-NLS-1$
	public static final String EXECUTION_RESULT_NODE = "executionResultNode"; //$NON-NLS-1$
	public static final String TESTSUITE_FILE_NODE = "testSuiteFileNode"; //$NON-NLS-1$
	public static final String TESTSUITE_NODE = "testSuiteNode"; //$NON-NLS-1$
	public static final String TESTCASE_NODE = "testCaseNode"; //$NON-NLS-1$
	public static final String TESTCOMPONENT_FILE_NODE = "testComponentFileNode"; //$NON-NLS-1$
	public static final String TESTCOMPONENT_NODE = "testComponentNode"; //$NON-NLS-1$
	public static final String DEPLOY_NODE = "deployNode"; //$NON-NLS-1$
	public static final String DEPLOY_FILE_NODE = "deployFileNode"; //$NON-NLS-1$
	public static final String LOCATION_NODE = "locationNode"; //$NON-NLS-1$
	public static final String LOCATION_FILE_NODE = "locationFileNode"; //$NON-NLS-1$
	public static final String TAG_CHILD = "childNode"; //$NON-NLS-1$
	//added for html file by maish02@ca.com
	public static final String HTML_FILE_NODE = "htmlFileNode"; //$NON-NLS-1$
	
	/**
	 * Color for a pass verdict.
	 *
	 * @provisional As of TPTP V4.5.3, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public static final RGB COLOR_PASS = new RGB(96, 200, 0);

	/**
	 * Color for a fail verdict.
	 *
	 * @provisional As of TPTP V4.5.3, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public static final RGB COLOR_FAIL = new RGB(248, 48, 0);
	
	/**
	 * Color for an error verdict.
	 *
	 * @provisional As of TPTP V4.5.3, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public static final RGB COLOR_ERROR = new RGB(248, 200, 48);
	
	/**
	 * Color for an inconclusive verdict.
	 *
	 * @provisional As of TPTP V4.5.3, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public static final RGB COLOR_INCONCLUSIVE = new RGB(96, 152, 248);
}
