/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestUIExtension.java,v 1.6 2008/03/06 16:37:56 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui;

import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.ui.HyadesUI;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;

/**
 * Contains utility methods to work with the Test UI extensions.
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version March 6, 2008
 * @since   February 1, 2005
 */
public class TestUIExtension
{
	private static class TestSuiteDescriptorFilter
	implements IAssociationDescriptorFilter
	{
		/**
		 * @see org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter#isValid(org.eclipse.hyades.ui.extension.IAssociationMapping, org.eclipse.hyades.ui.extension.IAssociationDescriptor)
		 */
		public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor)
		{
			if(!ICommonConstants.TEST_SUITE_FILE_EXTENSION.equals(associationDescriptor.getExtension()))
				return false;

			String extensionPoint = associationMapping.getExtensionPoint();
			if(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS.equals(extensionPoint))
			{
				if(associationDescriptor.applyToAllTypes())
					return false;
						
				if(associationDescriptor.types().length != 1)
					return false;
			}
			else if(HyadesUIPlugin.EP_EDITOR_EXTENSIONS.equals(extensionPoint))
			{
				if(associationDescriptor.getImageDescriptor() == null)
					associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FILE));
			}
			else if(HyadesUIPlugin.EP_TYPE_VALIDATORS.equals(extensionPoint))
			{
				if(associationDescriptor.applyToAllTypes())
					return false;
			}
			else if(UiPlugin.EP_GENERATE_WIZARDS.equals(extensionPoint))
			{
				if(associationDescriptor.applyToAllTypes())
					return false;
			}
			/*else if(UiPlugin.EP_RUN_WIZARDS.equals(extensionPoint))
			{
				if(associationDescriptor.applyToAllTypes())
					return false;
			}*/
			
			return true;
		}
	}
	
	private static class TestCaseDescriptorFilter
	implements IAssociationDescriptorFilter
	{
		/**
		 * @see org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter#isValid(org.eclipse.hyades.ui.extension.IAssociationMapping, org.eclipse.hyades.ui.extension.IAssociationDescriptor)
		 */
		public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor)
		{
			boolean isTestCaseWizard = UiPlugin.EP_TEST_CASE_WIZARD.equals(associationMapping.getExtensionPoint()); 
			boolean isTestCaseExtension = ICommonConstants.TEST_CASE_EXTENSION.equals(associationDescriptor.getExtension());
			
			if((!isTestCaseExtension) && (!isTestCaseWizard))
				return false;

			return true;
		}
	}	

	private static class DeploymentDescriptorFilter
	implements IAssociationDescriptorFilter
	{
		/**
		 * @see org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter#isValid(org.eclipse.hyades.ui.extension.IAssociationMapping, org.eclipse.hyades.ui.extension.IAssociationDescriptor)
		 */
		public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor)
		{
			if(!ICommonConstants.DEPLOYMENT_FILE_EXTENSION.equals(associationDescriptor.getExtension()))
				return false;

			String extensionPoint = associationMapping.getExtensionPoint();
			if(HyadesUIPlugin.EP_EDITOR_EXTENSIONS.equals(extensionPoint))
			{
				if(associationDescriptor.getImageDescriptor() == null)
					associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FILE));
			}
			
			return true;
		}
	}	

	private static class ExecutionDescriptorFilter
	implements IAssociationDescriptorFilter
	{
		/**
		 * @see org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter#isValid(org.eclipse.hyades.ui.extension.IAssociationMapping, org.eclipse.hyades.ui.extension.IAssociationDescriptor)
		 */
		public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor)
		{
			if(!ICommonConstants.EXECUTION_FILE_EXTENSION.equals(associationDescriptor.getExtension()))
				return false;

			String extensionPoint = associationMapping.getExtensionPoint();
			if(HyadesUIPlugin.EP_EDITOR_EXTENSIONS.equals(extensionPoint))
			{
				if(associationDescriptor.getImageDescriptor() == null)
					associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FILE));
			}
			
			return true;
		}
	}	

	private static class DatapoolDescriptorFilter
	implements IAssociationDescriptorFilter
	{
		/**
		 * @see org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter#isValid(org.eclipse.hyades.ui.extension.IAssociationMapping, org.eclipse.hyades.ui.extension.IAssociationDescriptor)
		 */
		public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor)
		{
			if(!ICommonConstants.DATAPOOL_FILE_EXTENSION.equals(associationDescriptor.getExtension()))
				return false;

			String extensionPoint = associationMapping.getExtensionPoint();
			if(HyadesUIPlugin.EP_EDITOR_EXTENSIONS.equals(extensionPoint))
			{
				if(associationDescriptor.getImageDescriptor() == null)
					associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FILE));
			}
			
			return true;
		}
	}	

	private static class ArtifactDescriptorFilter
	implements IAssociationDescriptorFilter
	{
		/**
		 * @see org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter#isValid(org.eclipse.hyades.ui.extension.IAssociationMapping, org.eclipse.hyades.ui.extension.IAssociationDescriptor)
		 */
		public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor)
		{
			if(!ICommonConstants.ARTIFACT_FILE_EXTENSION.equals(associationDescriptor.getExtension()))
				return false;

			String extensionPoint = associationMapping.getExtensionPoint();
			if(HyadesUIPlugin.EP_EDITOR_EXTENSIONS.equals(extensionPoint))
			{
				if(associationDescriptor.getImageDescriptor() == null)
					associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FILE));
			}
			
			return true;
		}
	}	

	private static class LocationDescriptorFilter
	implements IAssociationDescriptorFilter
	{
		/**
		 * @see org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter#isValid(org.eclipse.hyades.ui.extension.IAssociationMapping, org.eclipse.hyades.ui.extension.IAssociationDescriptor)
		 */
		public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor)
		{
			if(!ICommonConstants.LOCATION_FILE_EXTENSION.equals(associationDescriptor.getExtension()))
				return false;

			String extensionPoint = associationMapping.getExtensionPoint();
			if(HyadesUIPlugin.EP_EDITOR_EXTENSIONS.equals(extensionPoint))
			{
				if(associationDescriptor.getImageDescriptor() == null)
					associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FILE));
			}
			
			return true;
		}
	}	
	
	//Bugzilla #68553 by maish02@ca.com
	//Commented out for bugzilla #95329 - george.sebastian@ca.com
	/*	
	private static class HTMLDescriptorFilter
	implements IAssociationDescriptorFilter
	{

		public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor)
		{
			if(!TestUIConstants.HTML_FILE_EXTENSION.equals(associationDescriptor.getExtension()))
				return false;

			String extensionPoint = associationMapping.getExtensionPoint();
			if(HyadesUIPlugin.EP_EDITOR_EXTENSIONS.equals(extensionPoint))
			{
				if(associationDescriptor.getImageDescriptor() == null)
					associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FILE));
			}
			
			return true;
		}
	}	
	*/	
	/**
	 * The Hyades generic test suite type
	 */
	public final static String GENERIC_TEST_SUITE_TYPE = "org.eclipse.hyades.testSuite.generic"; //$NON-NLS-1$

	/**
	 * The Hyades generic test suite editor that is registered to the Eclipse
	 * framework. 
	 */
	public final static String GENERIC_TEST_SUITE_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart"; //$NON-NLS-1$

	/**
	 * The Hyades generic test case type
	 */
	public final static String GENERIC_TEST_CASE_TYPE = "org.eclipse.hyades.testCase.generic"; //$NON-NLS-1$

	/**
	 * The Hyades deployment editor that is registered to the Eclipse
	 * framework. 
	 */
	public final static String DEPLOYMENT_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.DeploymentEditorPart"; //$NON-NLS-1$

	/**
	 * The Hyades execution result editor that is registered to the Eclipse
	 * framework. 
	 */
	public final static String EXECUTION_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.forms.editor.TestLogViewer"; //$NON-NLS-1$

	/**
	 * The Hyades datapool type
	 */
	public final static String GENERIC_DATAPOOL_TYPE = "org.eclipse.hyades.datapool.generic"; //$NON-NLS-1$

	/**
	 * The Hyades datapool editor that is registered to the Eclipse
	 * framework. 
	 */
	public final static String DATAPOOL_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.DatapoolEditorPart"; //$NON-NLS-1$

	/**
	 * The Hyades artifact type
	 */
	public final static String GENERIC_ARTIFACT_TYPE = "org.eclipse.hyades.artifact.generic"; //$NON-NLS-1$

	/**
	 * The Hyades artifact editor that is registered to the Eclipse
	 * framework. 
	 */
	public final static String ARTIFACT_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.ArtifactEditorPart"; //$NON-NLS-1$

	/**
	 * The Hyades location type
	 */
	public final static String GENERIC_LOCATION_TYPE = "org.eclipse.hyades.location.generic"; //$NON-NLS-1$

	/**
	 * The Hyades datapool editor that is registered to the Eclipse
	 * framework. 
	 */
	public final static String LOCATION_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.LocationEditorPart"; //$NON-NLS-1$

	/**
	 * TODO
	 * The Hyades html editor that is registered to the Eclipse
	 * framework. 
	 */
	//	Bugzilla #68553 by maish02@ca.com
	//Commented out for bugzilla #95329 - george.sebastian@ca.com	
	//public final static String HTML_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.HTMLEditorPart"; //$NON-NLS-1$

	
	/*
	 * Association mapping registries.
	 */
	private static IAssociationMappingRegistry testSuiteMappingRegistry;
	private static IAssociationMappingRegistry testCaseMappingRegistry;
	private static IAssociationMappingRegistry deploymentMappingRegistry;
	private static IAssociationMappingRegistry executionMappingRegistry;
	private static IAssociationMappingRegistry datapoolMappingRegistry;
	private static IAssociationMappingRegistry locationMappingRegistry;
	private static IAssociationMappingRegistry artifactMappingRegistry;
//	Bugzilla #68553 by maish02@ca.com
	//Commented out for bugzilla #95329 - george.sebastian@ca.com
	//private static IAssociationMappingRegistry htmlMappingRegistry;
	
	
	/**
	 * Disposes the resources used by this class.
	 */
	static void dispose()
	{
		if(testSuiteMappingRegistry != null)
			testSuiteMappingRegistry.dispose();

		if(testCaseMappingRegistry != null)
			testCaseMappingRegistry.dispose();
			
		if(deploymentMappingRegistry != null)
			deploymentMappingRegistry.dispose();	

		if(executionMappingRegistry != null)
			executionMappingRegistry.dispose();	

		if(datapoolMappingRegistry != null)
			datapoolMappingRegistry.dispose();	

		if(locationMappingRegistry != null)
			locationMappingRegistry.dispose();	

		if(artifactMappingRegistry != null)
			artifactMappingRegistry.dispose();
//		Bugzilla #68553 by maish02@ca.com
//Commented out for bugzilla #95329 - george.sebastian@ca.com
		//if(htmlMappingRegistry != null)
		//	htmlMappingRegistry.dispose();	

	}
	
	/**
	 * Returns the Test Suite's Association mapping registry.
	 * 
	 * <p>When this method is called for the first time it initializes
	 * the registry.
	 * 
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry getTestSuiteMappingRegistry()
	{
		if(testSuiteMappingRegistry == null)
		{
			testSuiteMappingRegistry = HyadesUI.createAssociationMappingRegistry();
			testSuiteMappingRegistry.initialize(ICommonConstants.TEST_SUITE_FILE_EXTENSION, new TestSuiteDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
			
			testSuiteMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS, HyadesUIPlugin.getID());
			testSuiteMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS, HyadesUIPlugin.getID());
			testSuiteMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_TYPE_VALIDATORS, HyadesUIPlugin.getID());
			testSuiteMappingRegistry.retrieveAssociationMapping(UiPlugin.EP_GENERATE_WIZARDS, UiPlugin.getID());
			//testSuiteMappingRegistry.retrieveAssociationMapping(UiPlugin.EP_RUN_WIZARDS, UiPlugin.getID());			
		}
		
		return testSuiteMappingRegistry;
	}
	
	/**
	 * Returns the Test Case's Association mapping registry.
	 * 
	 * <p>When this method is called for the first time it initializes
	 * the registry.
	 * 
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry getTestCaseMappingRegistry()
	{
		if(testCaseMappingRegistry == null)
		{
			testCaseMappingRegistry = HyadesUI.createAssociationMappingRegistry();
			testCaseMappingRegistry.initialize(ICommonConstants.TEST_CASE_EXTENSION, new TestCaseDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
			
			testCaseMappingRegistry.retrieveAssociationMapping(UiPlugin.EP_TEST_CASE_WIZARD, UiPlugin.getID());
			testCaseMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS, HyadesUIPlugin.getID());
			testCaseMappingRegistry.retrieveAssociationMapping(UiPlugin.EP_GENERATE_WIZARDS, UiPlugin.getID());
			//testCaseMappingRegistry.retrieveAssociationMapping(UiPlugin.EP_RUN_WIZARDS, UiPlugin.getID());			
		}
		
		return testCaseMappingRegistry;
	}

	/**
	 * Returns the Deployment's Association mapping registry.
	 * 
	 * <p>When this method is called for the first time it initializes
	 * the registry.
	 * 
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry getDeploymentMappingRegistry()
	{
		if(deploymentMappingRegistry == null)
		{
			deploymentMappingRegistry = HyadesUI.createAssociationMappingRegistry();
			deploymentMappingRegistry.initialize(ICommonConstants.DEPLOYMENT_FILE_EXTENSION, new DeploymentDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
			
			deploymentMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS, HyadesUIPlugin.getID());
		}
		
		return deploymentMappingRegistry;
	}

	/**
	 * Returns the Execution Result's Association mapping registry.
	 * 
	 * <p>When this method is called for the first time it initializes
	 * the registry.
	 * 
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry getExecutionMappingRegistry()
	{
		if(executionMappingRegistry == null)
		{
			executionMappingRegistry = HyadesUI.createAssociationMappingRegistry();
			executionMappingRegistry.initialize(ICommonConstants.EXECUTION_FILE_EXTENSION, new ExecutionDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
			
			executionMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS, HyadesUIPlugin.getID());
		}
		
		return executionMappingRegistry;
	}

	/**
	 * @author psun
	 * Returns the DataPool's Association mapping registry.
	 * 
	 * <p>When this method is called for the first time it initializes
	 * the registry.
	 * 
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry getDatapoolMappingRegistry()
	{
		if(datapoolMappingRegistry == null)
		{
			datapoolMappingRegistry = HyadesUI.createAssociationMappingRegistry();
			datapoolMappingRegistry.initialize(ICommonConstants.DATAPOOL_FILE_EXTENSION, new DatapoolDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
			
			datapoolMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS, HyadesUIPlugin.getID());
		}
		
		return datapoolMappingRegistry;
	}

	/**
	 * @author psun
	 * Returns the artifact's Association mapping registry.
	 * 
	 * <p>When this method is called for the first time it initializes
	 * the registry.
	 * 
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry getArtifactMappingRegistry()
	{
		if(artifactMappingRegistry == null)
		{
			artifactMappingRegistry = HyadesUI.createAssociationMappingRegistry();
			artifactMappingRegistry.initialize(ICommonConstants.ARTIFACT_FILE_EXTENSION, new ArtifactDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
			
			artifactMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS, HyadesUIPlugin.getID());
		}
		
		return artifactMappingRegistry;
	}

	/**
	 * Bugzilla #68553 by maish02@ca.com
	 * @author 
	 * Returns the html's Association mapping registry.
	 * 
	 * <p>When this method is called for the first time it initializes
	 * the registry.
	 * 
	 * @return IAssociationMappingRegistry
	 */
	//Commented out for bugzilla #95329 - george.sebastian@ca.com
	/*
	public static IAssociationMappingRegistry getHTMLMappingRegistry()
	{
		if(htmlMappingRegistry == null)
		{
			htmlMappingRegistry = HyadesUI.createAssociationMappingRegistry();
			htmlMappingRegistry.initialize(TestUIConstants.HTML_FILE_EXTENSION, new HTMLDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
			
			htmlMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS, HyadesUIPlugin.getID());
		}
		
		return htmlMappingRegistry;
	}
	*/
	/**
	 * @author psun
	 * Returns the location's Association mapping registry.
	 * 
	 * <p>When this method is called for the first time it initializes
	 * the registry.
	 * 
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry getLocationMappingRegistry()
	{
		if(locationMappingRegistry == null)
		{
			locationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
			locationMappingRegistry.initialize(ICommonConstants.LOCATION_FILE_EXTENSION, new LocationDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
			
			locationMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS, HyadesUIPlugin.getID());
		}
		
		return locationMappingRegistry;
	}
	
	

	/**
	 * Registers a test suite type to this Eclipse session cache.
	 * 
	 * <p>This is the mechanism available for a Hyades component - such as an
	 * editor - to register the type of test suite it is manipulating.  This is 
	 * necessary since there is no global registry of all the test suite types available.
	 * 
	 * @param type
	 */
	public synchronized static void registerTestSuiteType(String type)
	{
		if(type == null)
			return;
			
		IAssociationMapping mapping = getTestSuiteMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS); 
		if(mapping.getAssociationDescriptors(type).length == 0)
		{
			IAssociationDescriptor descriptor = mapping.createAssociationDescriptor();
			descriptor.setExtension(ICommonConstants.TEST_SUITE_FILE_EXTENSION);
			descriptor.addType(type);
		}
	}
	
	/**
	 * Registers a test type to this Eclipse session cache.
	 * 
	 * <p>This is the mechanism available for a Hyades component - such as an
	 * editor - to register the type of test case it is manipulating.  This is 
	 * necessary since there is no global registry of all the test case types available.
	 * 
	 * @param type
	 */
	public synchronized static void registerTestCaseType(String type)
	{
		if(type == null)
			return;
			
		IAssociationMapping mapping = getTestCaseMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS); 
		if(mapping.getAssociationDescriptors(type).length == 0)
		{
			IAssociationDescriptor descriptor = mapping.createAssociationDescriptor();
			descriptor.setExtension(ICommonConstants.TEST_CASE_EXTENSION);
			descriptor.addType(type);
		}
	}
}
