/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestUIImages.java,v 1.32 2010/05/21 15:28:57 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui;

import java.net.URL;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * <p>Test UI image manager.</p>
 * 
 * <p><b>Note:</b>This class is not intended to be extended 
 * or used externally, and images are subject to be changed 
 * without notice.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Marcelo Paternostro
 * @author  Blazej Kroll
 * @version May 21, 2010
 * @since   February 1, 2005
 */
public class TestUIImages extends ImageManager {
		
    /**
     * HyadesUIImages' singleton.
     */
    public static final TestUIImages INSTANCE = new TestUIImages();

    /**
	 * No-argument constructor.
	 */
	public TestUIImages(){
		
		try	{
			initialize(new URL(UiPlugin.getDefault().getBundle().getEntry("/"), "icons/full/"), UiPlugin.getDefault().getImageRegistry()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch(Exception e) {
			UiPlugin.logError(e);
		}	
	}
	
    /*
     * Available cached Images in the Java plugin image registry.
     */
    public static final String IMG_WIZBAN_NEWTESTSUITE = "newtestsuite_wiz.gif"; //$NON-NLS-1$
    public static final String IMG_WIZBAN_NEWDEPLOYMENT = "newdeployment_wiz.gif"; //$NON-NLS-1$
    public static final String IMG_WIZBAN_RUN = "run_wiz.gif"; //$NON-NLS-1$
    public static final String IMG_WIZBAN_NEWARTIFACT = "new_artifact_wiz.gif"; //$NON-NLS-1$
    public static final String IMG_WIZBAN_NEWLOCATION = "new_location_wiz.gif"; //$NON-NLS-1$
    public static final String IMG_WIZBAN_NEWTESTCASE = "newtestcase_wiz.gif"; //$NON-NLS-1$
    public static final String IMG_WIZBAN_NEWDATAPOOL = "new_datapool_wiz.gif"; //$NON-NLS-1$
    public static final String IMG_WIZBAN_EXPORT_DATAPOOL = "export_datapool_wiz.gif"; //$NON-NLS-1$
	public static final String IMG_WIZBAN_IMPORT_DATAPOOL = "import_datapool_wiz.gif"; //$NON-NLS-1$
	public static final String IMG_WIZBAN_IMPORT_XML_TEST_LOG = "import_xml_test_log_wiz.gif"; //$NON-NLS-1$
    public static final String IMG_WIZBAN_REPORT = "report_wiz.gif"; //$NON-NLS-1$

    public static final String IMG_TEST_SUITE = "testsuite_obj.gif"; //$NON-NLS-1$
    public static final String IMG_TEST_CASE = "testcase_obj.gif"; //$NON-NLS-1$
    public static final String IMG_TEST_COMPONENT = "testcomponent_obj.gif"; //$NON-NLS-1$
    public static final String IMG_ARBITER = "arbiter_obj.gif"; //$NON-NLS-1$
    public static final String IMG_FILE = "file_obj.gif"; //$NON-NLS-1$
    public static final String IMG_DEPLOYMENT = "deployment_obj.gif"; //$NON-NLS-1$
    public static final String IMG_DEPLOYMENT_SPEC = "deployspec_obj.gif"; //$NON-NLS-1$
    public static final String IMG_LOCATION = "location_obj.gif"; //$NON-NLS-1$
    public static final String IMG_PROPERTY_GROUP = "propertyGroup_obj.gif"; //$NON-NLS-1$
    public static final String IMG_PROPERTY = "property_obj.gif"; //$NON-NLS-1$
    public static final String IMG_REPORT = "report_obj.gif"; //$NON-NLS-1$
    public static final String IMG_BEHAVIOR = "behavior_obj.gif"; //$NON-NLS-1$
    public static final String IMG_SUT = "sut_obj.gif"; //$NON-NLS-1$
    public static final String IMG_TESTLOG = "testlog_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EXECUTION = "execution_obj.gif"; //$NON-NLS-1$
    public static final String IMG_DATAPOOL = "datapool_obj.gif"; //$NON-NLS-1$
    public static final String IMG_DATAPOOL_ENCRYPTED_VARIABLE = "datapool_encrypted_variable_obj.gif"; //$NON-NLS-1$
    public static final String IMG_ARTIFACT = "artifact_obj.gif"; //$NON-NLS-1$
    public static final String IMG_DOWNARROW = "downArrow.gif"; //$NON-NLS-1$
    // icons added for HTN : BCO (3/5/04)
    public static final String IMG_VERDICT_ERROR = "verdict_error.gif"; //$NON-NLS-1$
    public static final String IMG_VERDICT_FAILED = "verdict_failed.gif"; //$NON-NLS-1$
    public static final String IMG_VERDICT_INC = "verdict_inc.gif"; //$NON-NLS-1$
    public static final String IMG_VERDICT_PASSED = "verdict_passed.gif"; //$NON-NLS-1$

    public static final String IMG_EVENT_EXECUTION = "eveexecution_obj.gif"; //$NON-NLS-1$
    // modified the icons to have separate images for different invocation events :BGB(12/1/03)
    public static final String IMG_EVENT_INVOCATION = "eveinvocation_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_INVOCATION_PASS = "eveinvocationpass_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_INVOCATION_FAIL = "eveinvocationfail_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_INVOCATION_INCONCLUSIVE = "eveinvocationinc_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_INVOCATION_ERROR = "eveinvocationerror_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_MESSAGE = "evemessage_obj.gif"; //$NON-NLS-1$
    // modified the icons to have separate images for different typed events :BGB(12/1/03)
    public static final String IMG_EVENT_TYPED = "evetyped_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_TYPED_START = "evetypedstart_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_TYPED_STOP = "evetypedstop_obj.gif"; //$NON-NLS-1$
    // modified the icons to have separate images for different typed events :BGB(12/1/03)
    public static final String IMG_EVENT_VERDICT = "eveverdict_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_VERDICT_PASS = "eveverdictpass_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_VERDICT_FAIL = "eveverdictfail_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_VERDICT_INCONCLUSIVE = "eveverdictinc_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_VERDICT_ERROR = "eveverdicterror_obj.gif"; //$NON-NLS-1$
    //image file for test log view partition by bkoll (bug 239294)
    public static final String IMG_EVENT_PARTITION = "partition_obj.gif"; //$NON-NLS-1$
    // added new loop event :BGB(12/1/03)
    public static final String IMG_EVENT_LOOP = "eveloop_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_WAIT = "eventWait_obj.gif"; //$NON-NLS-1$
    public static final String IMG_EVENT_TIMED = "eventTimed_obj.gif"; //$NON-NLS-1$
    
    public static final String IMG_STACK_FRAME = "stkfrm_obj.gif"; //$NON-NLS-1$
    public static final String IMG_CATCH_CLAUSE = "exc_catch.gif"; //$NON-NLS-1$
    
    public static final String IMG_UNCHECKED = "unchecked_obj.gif"; //$NON-NLS-1$
    public static final String IMG_ERROR = "error_obj.gif"; //$NON-NLS-1$

    public static final String ACT_SHOW_FOLDER = "showfolders_co.gif"; //$NON-NLS-1$
    public static final String ACT_SHOW_EOBJECT_CHILDREN = "showchild_co.gif"; //$NON-NLS-1$
    public static final String ACT_NEW_TEST_SUITE = "newtestsuite_wiz.gif"; //$NON-NLS-1$
    public static final String ACT_NEW_DEPLOYMENT = "newdeployment_wiz.gif"; //$NON-NLS-1$
    public static final String ACT_DOWN = "down_nav.gif"; //$NON-NLS-1$
    public static final String ACT_UP = "up_nav.gif"; //$NON-NLS-1$

    public static final String IMG_LCONFIG_TEST_TAB = "launch_testtab.gif"; //$NON-NLS-1$
    public static final String IMG_LCONFIG_TCOMPONENT_TAB = "launch_tcomponenttab.gif"; //$NON-NLS-1$
    public static final String IMG_LCONFIG_EXECRESULTS_TAB = "launch_execresultstab.gif"; //$NON-NLS-1$

    public static final String IMG_DEFAULT = IMG_UNCHECKED;
    public static final String GENERATE_TEST = "generate_test.gif"; //$NON-NLS-1$
    
    public static final String RESOURCE_VIEW = "resource_view.gif"; //$NON-NLS-1$
    public static final String LOGICAL_VIEW = "logical_view.gif"; //$NON-NLS-1$
	
	public static final String IMG_RESUME = "resume_co.gif"; //$NON-NLS-1$
	public static final String IMG_SUSPEND = "suspend_co.gif"; //$NON-NLS-1$

	/**
	 * When used as background image, this image should be used with caution for accessibility reason. 
	 * Because background image that does not change with the system background color changes in Windows "High Constrast" mode
	 * will not be accessibility compliant.
	 */
    public static final String IMG_FORM_BANNER = "form_banner.gif"; //$NON-NLS-1$
	public static final String IMG_HORIZONTAL = "th_horizontal.gif"; //$NON-NLS-1$
	public static final String IMG_VERTICAL = "th_vertical.gif"; //$NON-NLS-1$
	
	public static final String IMG_VERDICT_NAV_FIRST = "first_ver.gif"; //$NON-NLS-1$
    public static final String IMG_VERDICT_NAV_PREV = "prev_ver.gif"; //$NON-NLS-1$
    public static final String IMG_VERDICT_NAV_NEXT = "next_ver.gif"; //$NON-NLS-1$
    public static final String IMG_VERDICT_NAV_LAST = "last_ver.gif"; //$NON-NLS-1$    
    public static final String IMG_VERDICT_NON = "non_ver.gif"; //$NON-NLS-1$
    
    public static final String IMG_COLLAPSE_ALL = "collapseall.gif"; //$NON-NLS-1$
    public static final String IMG_EXPAND_ALL = "expandall.gif"; //$NON-NLS-1$
    public static final String IMG_GEN_RECORDER_WIZ = "gen_recorder_wiz.gif";
    public static final String IMG_STOP_RECORDING = "stoprecording.gif"; //$NON-NLS-1$
    public static final String IMG_GEN_RECORD = "gen_record_obj.gif"; //$NON-NLS-1$
    public static final String IMG_REFRESH_NAV = "refresh_nav.gif"; //$NON-NLS-1$
    public static final String IMG_LOG_SEARCH = "log_search.gif"; //$NON-NLS-1$

    //Reuse the default report image for the typed reports:
    public static final String IMG_HTML = IMG_REPORT;
    public static final String IMG_XML = IMG_REPORT;
    public static final String IMG_RTF = IMG_REPORT;

    /**
     * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
     */
    protected void addImages() {
        add(T_WIZBAN, IMG_WIZBAN_NEWTESTSUITE);
        add(T_WIZBAN, IMG_WIZBAN_RUN);
        add(T_WIZBAN, IMG_WIZBAN_NEWDEPLOYMENT);
        add(T_WIZBAN, IMG_FORM_BANNER);
        add(T_WIZBAN, IMG_WIZBAN_NEWTESTCASE);
        add(T_WIZBAN, IMG_WIZBAN_EXPORT_DATAPOOL);
		add(T_WIZBAN, IMG_WIZBAN_IMPORT_DATAPOOL);
		add(T_WIZBAN, IMG_WIZBAN_IMPORT_XML_TEST_LOG);
        add(T_WIZBAN, IMG_WIZBAN_NEWDATAPOOL);
        add(T_WIZBAN, IMG_WIZBAN_NEWARTIFACT);
        add(T_WIZBAN, IMG_WIZBAN_NEWLOCATION);
        add(T_WIZBAN, IMG_WIZBAN_REPORT);

        add(T_OBJ, IMG_TEST_SUITE);
        add(T_OBJ, IMG_TEST_CASE);
        add(T_OBJ, IMG_TEST_COMPONENT);
        add(T_OBJ, IMG_ARBITER);
        add(T_OBJ, IMG_FILE);
        add(T_OBJ, IMG_DEPLOYMENT);
        add(T_OBJ, IMG_DEPLOYMENT_SPEC);
        add(T_OBJ, IMG_LOCATION);
        add(T_OBJ, IMG_PROPERTY_GROUP);
        add(T_OBJ, IMG_PROPERTY);
        add(T_OBJ, IMG_REPORT);
        add(T_OBJ, IMG_BEHAVIOR);
        add(T_OBJ, IMG_SUT);
        add(T_OBJ, IMG_TESTLOG);
        add(T_OBJ, IMG_EXECUTION);
        add(T_OBJ, IMG_DATAPOOL);
        add(T_OBJ, IMG_DATAPOOL_ENCRYPTED_VARIABLE);
        add(T_OBJ, IMG_ARTIFACT);
        add(T_OBJ, IMG_DOWNARROW);

        add(T_OBJ, IMG_EVENT_EXECUTION);
        //modified the icons to have separate images for different invocation events :BGB(12/1/03)
        add(T_OBJ, IMG_EVENT_INVOCATION);
        add(T_OBJ, IMG_EVENT_INVOCATION_PASS);
        add(T_OBJ, IMG_EVENT_INVOCATION_FAIL);
        add(T_OBJ, IMG_EVENT_INVOCATION_INCONCLUSIVE);
        add(T_OBJ, IMG_EVENT_INVOCATION_ERROR);
        add(T_OBJ, IMG_EVENT_MESSAGE);
        //icon for test log view partition by bkroll
        add(T_OBJ, IMG_EVENT_PARTITION);
        //modified the icons to have separate images for different typed events :BGB(12/1/03)
        add(T_OBJ, IMG_EVENT_TYPED);
        add(T_OBJ, IMG_EVENT_TYPED_START);
        add(T_OBJ, IMG_EVENT_TYPED_STOP);
        //modified the icons to have separate images for different verdict events :BGB(12/1/03)
        add(T_OBJ, IMG_EVENT_VERDICT);
        add(T_OBJ, IMG_EVENT_VERDICT_PASS);
        add(T_OBJ, IMG_EVENT_VERDICT_FAIL);
        add(T_OBJ, IMG_EVENT_VERDICT_INCONCLUSIVE);
        add(T_OBJ, IMG_EVENT_VERDICT_ERROR);
        //added new loop event :BGB(12/1/03)
        add(T_OBJ, IMG_EVENT_LOOP);
        add(T_OBJ, IMG_EVENT_TIMED);
        add(T_OBJ, IMG_EVENT_WAIT);

        add(T_OBJ, IMG_STACK_FRAME);
        add(T_OBJ, IMG_CATCH_CLAUSE);
        add(T_OBJ, IMG_UNCHECKED);
        add(T_OBJ, IMG_ERROR);

        // Added by JC
        add(T_OBJ, IMG_LCONFIG_TEST_TAB);
        add(T_OBJ, IMG_LCONFIG_TCOMPONENT_TAB);
        add(T_OBJ, IMG_LCONFIG_EXECRESULTS_TAB);
        add(T_OBJ, IMG_GEN_RECORD);

        add("c", T_LCL, ACT_SHOW_FOLDER); //$NON-NLS-1$
        add("d", T_LCL, ACT_SHOW_FOLDER); //$NON-NLS-1$
        add("e", T_LCL, ACT_SHOW_FOLDER); //$NON-NLS-1$

        add("c", T_LCL, ACT_SHOW_EOBJECT_CHILDREN); //$NON-NLS-1$
        add("d", T_LCL, ACT_SHOW_EOBJECT_CHILDREN); //$NON-NLS-1$
        add("e", T_LCL, ACT_SHOW_EOBJECT_CHILDREN); //$NON-NLS-1$

        add("c", T_TOOL, ACT_NEW_TEST_SUITE); //$NON-NLS-1$
        add("e", T_TOOL, ACT_NEW_TEST_SUITE); //$NON-NLS-1$
        add("c", T_TOOL, ACT_NEW_DEPLOYMENT); //$NON-NLS-1$
        add("e", T_TOOL, ACT_NEW_DEPLOYMENT); //$NON-NLS-1$

        add("c", T_LCL, ACT_DOWN); //$NON-NLS-1$
        add("d", T_LCL, ACT_DOWN); //$NON-NLS-1$
        add("e", T_LCL, ACT_DOWN); //$NON-NLS-1$

        add("c", T_LCL, ACT_UP); //$NON-NLS-1$
        add("d", T_LCL, ACT_UP); //$NON-NLS-1$
        add("e", T_LCL, ACT_UP); //$NON-NLS-1$

        // Added by BCO (3/5/04)
        add(T_OVR, IMG_VERDICT_ERROR);
        add(T_OVR, IMG_VERDICT_PASSED);
        add(T_OVR, IMG_VERDICT_FAILED);
        add(T_OVR, IMG_VERDICT_INC);

        add("e", T_TOOL, GENERATE_TEST); //$NON-NLS-1$
        add("e", T_TOOL, RESOURCE_VIEW); //$NON-NLS-1$
        add("e", T_TOOL, LOGICAL_VIEW); //$NON-NLS-1$
		
		add("e", T_LCL, IMG_SUSPEND); //$NON-NLS-1$
		add("e", T_LCL, IMG_RESUME); //$NON-NLS-1$

		// added for Test log viewer by bjiang.
        add(T_OBJ, IMG_VERDICT_NON);

		add("e", T_LCL, IMG_HORIZONTAL);
		add("e", T_LCL, IMG_VERTICAL);
        add("e", T_LCL, IMG_VERDICT_NAV_FIRST);
        add("e", T_LCL, IMG_VERDICT_NAV_PREV);
        add("e", T_LCL, IMG_VERDICT_NAV_NEXT);
        add("e", T_LCL, IMG_VERDICT_NAV_LAST);
        add("e", T_LCL, IMG_COLLAPSE_ALL);
        add("e", T_LCL, IMG_EXPAND_ALL);
        add("e", T_LCL, IMG_REFRESH_NAV);
        
        add("d", T_LCL, IMG_VERDICT_NAV_FIRST);
        add("d", T_LCL, IMG_VERDICT_NAV_PREV);
        add("d", T_LCL, IMG_VERDICT_NAV_NEXT);
        add("d", T_LCL, IMG_VERDICT_NAV_LAST);
        add("d", T_LCL, IMG_COLLAPSE_ALL);
        add("d", T_LCL, IMG_EXPAND_ALL);
        
        add("d", T_LCL, IMG_EVENT_VERDICT);
        add("d", T_LCL, IMG_EVENT_VERDICT_PASS);
        add("d", T_LCL, IMG_EVENT_VERDICT_FAIL);
        add("d", T_LCL, IMG_EVENT_VERDICT_INCONCLUSIVE);
        add("d", T_LCL, IMG_EVENT_VERDICT_ERROR);
        add("d", T_LCL, IMG_REFRESH_NAV);
       
        add("c", T_TOOL, IMG_GEN_RECORDER_WIZ); //$NON-NLS-1$
        add("d", T_TOOL, IMG_GEN_RECORDER_WIZ); //$NON-NLS-1$

        add("c", T_LCL, IMG_STOP_RECORDING); //$NON-NLS-1$
        add("d", T_LCL, IMG_STOP_RECORDING); //$NON-NLS-1$
        
        add("e", T_TOOL, IMG_LOG_SEARCH); //$NON-NLS-1$
    }
}
