/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MoveFeatureChildrenDownAction.java,v 1.5 2007/03/22 14:42:09 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.action.model;

import java.util.ListIterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class handles the move down action of elements that are {@link org.eclipse.emf.ecore.EStructuralFeature}
 * of an {@link org.eclipse.emf.ecore.EObject}.
 * 
 * @author bjiang
 * @since  3.0
 */
public class MoveFeatureChildrenDownAction extends FeatureChildrenSelectionAction
{
	/**
	 * @param parent
	 * @param feature
	 */
	public MoveFeatureChildrenDownAction(EObject parent, EStructuralFeature feature)
	{
		super(UiPluginResourceBundle.LBL_DOWN, parent, feature); 
		
		setToolTipText(UiPluginResourceBundle.ACT_DOWN_DSC); 
		TestUIImages.INSTANCE.setImageDescriptors(this, TestUIImages.ACT_DOWN);
		
		if(!feature.isMany())
		    this.setEnabled(false);
	}
	
	/**
	 * All the children must belong to the same parent.
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		if(!super.updateSelection(selection))
			return false;
			
		EList allChildren = (EList)getEStructuralFeatureValue();
		if(allChildren == null)
		    return false;
		if(allChildren.size() <= 1)
		{
			getChildren().clear();
			return false;
		}
			
		if((getChildren().size() == 1) && (allChildren.get(allChildren.size()-1) == getChildren().get(0)))
		{
			getChildren().clear();
			return false;			
		}
				
		return true;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		EList allChildren = (EList)getEStructuralFeatureValue();
		if(allChildren == null || allChildren.size() <= 1)
			return;

		int botton = allChildren.size()-1;
		for(ListIterator i=getChildren().listIterator(getChildren().size()); i.hasPrevious(); )
		{
			Object element = i.previous();
			int index = allChildren.indexOf(element);
			if(index < 0)
				continue;

			if(index < botton)
			{
				allChildren.move(index, index+1);
			}
			else
			{
				botton--;
			}
		}

		setActionPerformed(true);
	}	
}
