/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CMNNamedElementPropertySource.java,v 1.7 2007/06/04 13:58:48 jptoomey Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.internal.model.CMNNamedElementUtil.UINamedElement;
import org.eclipse.hyades.test.ui.internal.model.CMNNamedElementUtil.UIProxyNamedElement;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.ui.adapter.NamedElementPropertySource;


public class CMNNamedElementPropertySource
extends NamedElementPropertySource
{
	public CMNNamedElementPropertySource(CMNNamedElement namedElement) {
		super(new UINamedElement(namedElement));		
	}
	
	/**
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public CMNNamedElementPropertySource(CMNNamedElementProxyNode proxy) {
		super(new UIProxyNamedElement(proxy));
	}
}