/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolVariablePropertySource.java,v 1.7 2007/03/22 14:42:08 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * This class is a {@link org.eclipse.ui.views.properties.IPropertySource2 IPropertySource2}
 * implemented for {@link org.eclipse.hyades.edit.datapool.IDatapoolVariable IDatapoolVariable}.
 * 
 * @author bjiang
 * @since  3.3
 */
public class DatapoolVariablePropertySource extends NamedElementPropertySource {

	public static final String PROPERTY_SOURCE_ROLE = "datapool.variable.propertySource.role"; //$NON-NLS-1$
	public static final String PROPERTY_SOURCE_SUGGESTED_TYPE = "datapool.propertySource.suggestedType"; //$NON-NLS-1$
	//private DPLSuggestedTypePropertySource suggestedTypeSource;
	
	/**
	 * @param namedElement
	 */
	public DatapoolVariablePropertySource(IDatapoolVariable variable) {
		super(variable);
		//this.suggestedTypeSource = new DPLSuggestedTypePropertySource((IDatapoolSuggestedType)variable.getSuggestedType());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {		
		//PropertyDescriptor suggestedTypePropDescriptor = new PropertyDescriptor(PROPERTY_SOURCE_SUGGESTED_TYPE, "Suggested Type");		
	    PropertyDescriptor suggestedTypePropDescriptor = new TextPropertyDescriptor(PROPERTY_SOURCE_SUGGESTED_TYPE, UiPluginResourceBundle.Word_Type); 
	    suggestedTypePropDescriptor.setCategory(UiPluginResourceBundle.Word_Attributes); 

		String[] comboValues = new String[5];
		comboValues[IDatapoolVariable.ROLE_UNSPECIFIED] = UiPluginResourceBundle.DatapoolEditor_VariableRoles_Unspecified; 
		comboValues[IDatapoolVariable.ROLE_INPUT_DATA] = UiPluginResourceBundle.DatapoolEditor_VariableRoles_Input; 
		comboValues[IDatapoolVariable.ROLE_OUTPUT_DATA] = UiPluginResourceBundle.DatapoolEditor_VariableRoles_Output; 
		comboValues[IDatapoolVariable.ROLE_INPUT_OUTPUT_DATA] = UiPluginResourceBundle.DatapoolEditor_VariableRoles_InputOutput; 
		comboValues[IDatapoolVariable.ROLE_VERIFICATION_DATA] = UiPluginResourceBundle.DatapoolEditor_VariableRoles_Verification; 
		PropertyDescriptor rolePropDescriptor = new ComboBoxPropertyDescriptor(PROPERTY_SOURCE_ROLE, UiPluginResourceBundle.DatapoolEditor_VariableRoles_Role, comboValues); 
		rolePropDescriptor.setCategory(UiPluginResourceBundle.Word_Attributes); 
		
		IPropertyDescriptor[] temp = new IPropertyDescriptor[]{suggestedTypePropDescriptor, rolePropDescriptor};
		IPropertyDescriptor[] superDescriptors = super.getPropertyDescriptors();
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[temp.length + superDescriptors.length];
		System.arraycopy(temp, 0, descriptors, 0, temp.length);
		System.arraycopy(superDescriptors, 0, descriptors, temp.length, superDescriptors.length);
		
		superDescriptors = null;
		temp = null;	
		
		return descriptors;
	}
	
	public Object getPropertyValue(Object id) {
		if(PROPERTY_SOURCE_SUGGESTED_TYPE.equals(id))
		{
			// can't use IDatapoolSuggestedType until it's part of the data model
		    //return ((IDatapoolSuggestedType)variable.getSuggestedType()).getSuggestedClassName();
			String type = ((DPLVariable)getNamedElement()).getType();
			type = (type == null) ? "" : type; //$NON-NLS-1$
		    return type;
		}
		else if(PROPERTY_SOURCE_ROLE.equals(id))
			return new Integer(((DPLVariable)getNamedElement()).getRoleAsInt());
		else
			return super.getPropertyValue(id);
	}
	public void setPropertyValue(Object id, Object value) {
		if(PROPERTY_SOURCE_SUGGESTED_TYPE.equals(id))
		{
			Object oldValue = getPropertyValue(id);
		    // can't use IDatapoolSuggestedType until it's part of the data model
			//((IDatapoolSuggestedType)variable.getSuggestedType()).setSuggestedClassName((String)value);
		    ((DPLVariable)getNamedElement()).setType((String)value);
			firePropertyChangeEvent(id.toString(), oldValue, value);
		}
		else if(PROPERTY_SOURCE_ROLE.equals(id) && value instanceof Integer)
		{
			Object oldValue = getPropertyValue(id);
		    ((IDatapoolVariable)getNamedElement()).setRole(((Integer)value).intValue());
		    firePropertyChangeEvent(id.toString(), oldValue, value);
		}
		else
			super.setPropertyValue(id, value);
	}
}
