/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PropertySourceLabelProvider.java,v 1.2 2005/07/26 21:27:10 mddunn Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertySource;

/**
 * Label provider for {@link org.eclipse.hyades.edit.datapool.INamedElement INamedElement}.
 * 
 * @author bjiang
 * @since  3.3
 */
public class PropertySourceLabelProvider extends LabelProvider {
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) {
	    if(element instanceof NamedElementPropertySource)
	        return ((NamedElementPropertySource)element).getNamedElement().getName();
		else if(element instanceof IPropertySource)
			return ((IPropertySource)element).toString();
		return null;
	}
}
