/********************************************************************** 
 * Copyright (c) 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: DeleteCellAction.java,v 1.1 2010/03/30 15:15:29 paules Exp $ 
 * 
 * Contributors: 
 * 		IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.action;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.internal.editor.DatapoolEditorPart;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.ui.IWorkbenchCommandConstants;
import org.eclipse.ui.PlatformUI;

/** 
 * <p>Delete cell action for the datapool table.</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version March 30, 2010
 * @since   March 30, 2010
 */
public class DeleteCellAction extends org.eclipse.hyades.ui.internal.editor.action.DeleteAction {

	private DatapoolTable table = null;

	public DeleteCellAction() {
		this(null);
	}

	public DeleteCellAction(DatapoolTable table) {

		super();

		this.table = table;

		setText(UiPluginResourceBundle.DELETE_CELL_TEXT); 
		setDescription(UiPluginResourceBundle.DELETE_CELL_LDESC);

		this.setId(this.getClass().getName());
		this.setActionDefinitionId(IWorkbenchCommandConstants.EDIT_DELETE);

		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this, UiPlugin.getID() + ContextIds.DELETE_CELL_ACT);        
	}

	public void run() {

		if (getFocusControl() instanceof TableCursor) {

			if(table != null){
				table.clearCell();
			}
			else{

				DatapoolEditorPart activeEditor = (DatapoolEditorPart) PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
				DatapoolTable currentTable = ((DatapoolEditorExtension) activeEditor.getEditorExtension()).getCurrentDatapoolTable();

				if (currentTable != null){
					currentTable.clearCell();
				}
			}
		} 
		else if (isValidFocusControl()){
			super.run();
		}
	}

	public void setTable(DatapoolTable table){
		this.table = table;
	}
}
