/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeleteColumnAction.java,v 1.7 2009/04/02 17:29:17 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.action;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.SelectionProviderAction;

/**
 * <p>Delete column action for the datapool table.</p>
 * 
 * 
 * @author  Peter Sun
 * @author  Paul E. Slauenwhite
 * @version April 2, 2009
 * @since   January 27, 2005
 */
public class DeleteColumnAction extends SelectionProviderAction {
	private DatapoolTable table;

	public DeleteColumnAction(ISelectionProvider viewer, DatapoolTable table)
	{
		super(viewer, UiPluginResourceBundle.DEL_COL_TEXT); 
		setDescription(UiPluginResourceBundle.DEL_COL_LDESC); 
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this, UiPlugin.getID() + ContextIds.DEL_COL_ACT);
		this.table = table;
	}

	public void run()
	{
		if (table != null)
			table.deleteColumn();
	}

	public void aboutToShow(boolean bShow)
	{
		setEnabled(bShow);
	}
	
}
