/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeleteRowAction.java,v 1.8 2010/03/24 16:18:41 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.action;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.SelectionProviderAction;

/**
 * <p>Delete row action for the datapool table.</p>
 * 
 * 
 * @author  Peter Sun
 * @author  Paul E. Slauenwhite
 * @version March 24, 2010
 * @since   January 27, 2005
 */
public class DeleteRowAction extends SelectionProviderAction {
	
	private DatapoolTable datapoolTable = null;

	public DeleteRowAction(ISelectionProvider viewer, DatapoolTable datapoolTable){
		
		super(viewer, UiPluginResourceBundle.DEL_ROW_TEXT); 
		
		this.datapoolTable = datapoolTable;

		setDescription(UiPluginResourceBundle.DEL_ROW_LDESC); 
		
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this, UiPlugin.getID() + ContextIds.DEL_ROW_ACT);
	}

	public void run(){
		
		if (datapoolTable != null){
			datapoolTable.deleteRow();
		}
	}

	public void aboutToShow(boolean aboutToShow){
		
		//Set the menu text for one or multiple selected row(s):
		if((datapoolTable != null) && (datapoolTable.getRowSelectionCount() > 1)){
			setText(UiPluginResourceBundle.DEL_ROWS_TEXT);			
		}
		else{
			setText(UiPluginResourceBundle.DEL_ROW_TEXT);
		}
		
		setEnabled(aboutToShow);
	}
	
}
