/********************************************************************** 
 * Copyright (c) 2007, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: FindReplaceAction.java,v 1.2 2009/05/12 18:30:00 paules Exp $ 
 * 
 * Contributors: 
 * 		IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.action;

import java.util.ResourceBundle;

import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchCommandConstants;
import org.eclipse.ui.IWorkbenchPart;

/** 
 * <p>Find and replace action for the datapool table.</p>
 * 
 * <p>Note: This action is only enabled if the table cursor is the focused control.</p>
 * 
 * 
 * @author  Patrick Nedelec
 * @author  Paul Slauenwhite
 * @version May 12, 2009
 * @since   February 27, 2007
 */
public class FindReplaceAction extends org.eclipse.ui.texteditor.FindReplaceAction {

	public FindReplaceAction(ResourceBundle bundle, String prefix, IWorkbenchPart workbenchPart) {
		super(bundle, prefix, workbenchPart);
	}

	public FindReplaceAction(ResourceBundle bundle, String prefix, Shell shell, IFindReplaceTarget target) {
		super(bundle, prefix, shell, target);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#getActionDefinitionId()
	 */
	public String getActionDefinitionId(){
		return (IWorkbenchCommandConstants.EDIT_FIND_AND_REPLACE);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.texteditor.FindReplaceAction#run()
	 */
	public void run() {
		
		//Run if the table cursor is the focused control:
		if (Display.getCurrent().getFocusControl() instanceof TableCursor) {
			super.run();
		}
	}
}
