/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PasteAction.java,v 1.11 2010/03/30 15:15:29 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.action;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.internal.editor.DatapoolEditorPart;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.ui.IWorkbenchCommandConstants;
import org.eclipse.ui.PlatformUI;

/**
 * Paste action for the datapool table.
 * <p/>
 * 
 * 
 * @author  Peter Sun
 * @author  Patrick Nedelec
 * @author  Paul E. Slauenwhite
 * @version March 30, 2010
 * @since   January 27, 2005
 */
public class PasteAction extends org.eclipse.hyades.ui.internal.editor.action.PasteAction {

	private DatapoolTable table = null;
	
    public PasteAction() {
        this(null);
    }

    public PasteAction(DatapoolTable table) {
        super();
        this.table = table;
        setText(UiPluginResourceBundle.PASTE_TEXT); 
        this.setId(this.getClass().getName());
        this.setActionDefinitionId(IWorkbenchCommandConstants.EDIT_PASTE);
        setDescription(UiPluginResourceBundle.PASTE_LDESC); 
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this, UiPlugin.getID() + ContextIds.PASTE_ACT);
    }

    public void run() {
    	
    	if (getFocusControl() instanceof TableCursor) {
        
    		if(table != null){
        		table.paste();
        	}
    		else{
    		
    			DatapoolEditorPart activeEditor = (DatapoolEditorPart) PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    			DatapoolTable currentTable = ((DatapoolEditorExtension) activeEditor.getEditorExtension()).getCurrentDatapoolTable();
            
    			if (currentTable != null){
    				currentTable.paste();
    			}
    		}
        } 
    	else if (isValidFocusControl()) {
            super.run();
        }
    }
    
    public void setTable(DatapoolTable table){
    	this.table = table;
    }
}
